package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait EffectivePermission {
  def unwrap: software.amazon.awssdk.services.macie2.model.EffectivePermission
}
object EffectivePermission {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.EffectivePermission
  ): zio.aws.macie2.model.EffectivePermission = value match {
    case software.amazon.awssdk.services.macie2.model.EffectivePermission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.EffectivePermission.PUBLIC =>
      val r = PUBLIC
      r
    case software.amazon.awssdk.services.macie2.model.EffectivePermission.NOT_PUBLIC =>
      val r = NOT_PUBLIC
      r
    case software.amazon.awssdk.services.macie2.model.EffectivePermission.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.EffectivePermission {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.EffectivePermission =
      software.amazon.awssdk.services.macie2.model.EffectivePermission.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC extends zio.aws.macie2.model.EffectivePermission {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.EffectivePermission =
      software.amazon.awssdk.services.macie2.model.EffectivePermission.PUBLIC
  }
  case object NOT_PUBLIC extends zio.aws.macie2.model.EffectivePermission {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.EffectivePermission =
      software.amazon.awssdk.services.macie2.model.EffectivePermission.NOT_PUBLIC
  }
  case object UNKNOWN extends zio.aws.macie2.model.EffectivePermission {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.EffectivePermission =
      software.amazon.awssdk.services.macie2.model.EffectivePermission.UNKNOWN
  }
}
