package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.macie2.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.ErrorCode
  ): zio.aws.macie2.model.ErrorCode = value match {
    case software.amazon.awssdk.services.macie2.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.ErrorCode.CLIENT_ERROR =>
      val r = ClientError
      r
    case software.amazon.awssdk.services.macie2.model.ErrorCode.INTERNAL_ERROR =>
      val r = InternalError
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ErrorCode =
      software.amazon.awssdk.services.macie2.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ClientError extends zio.aws.macie2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ErrorCode =
      software.amazon.awssdk.services.macie2.model.ErrorCode.CLIENT_ERROR
  }
  case object InternalError extends zio.aws.macie2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ErrorCode =
      software.amazon.awssdk.services.macie2.model.ErrorCode.INTERNAL_ERROR
  }
}
