package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{
  __integer,
  __boolean,
  __timestampIso8601,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetCustomDataIdentifierResponse(
    arn: Optional[__string] = Optional.Absent,
    createdAt: Optional[__timestampIso8601] = Optional.Absent,
    deleted: Optional[__boolean] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    ignoreWords: Optional[Iterable[__string]] = Optional.Absent,
    keywords: Optional[Iterable[__string]] = Optional.Absent,
    maximumMatchDistance: Optional[__integer] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    regex: Optional[__string] = Optional.Absent,
    severityLevels: Optional[Iterable[zio.aws.macie2.model.SeverityLevel]] =
      Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse = {
    import GetCustomDataIdentifierResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(deleted.map(value => value: java.lang.Boolean))(_.deleted)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(
        ignoreWords.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ignoreWords)
      .optionallyWith(
        keywords.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.keywords)
      .optionallyWith(maximumMatchDistance.map(value => value: Integer))(
        _.maximumMatchDistance
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(regex.map(value => value: java.lang.String))(_.regex)
      .optionallyWith(
        severityLevels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severityLevels)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.GetCustomDataIdentifierResponse.ReadOnly =
    zio.aws.macie2.model.GetCustomDataIdentifierResponse.wrap(buildAwsValue())
}
object GetCustomDataIdentifierResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetCustomDataIdentifierResponse =
      zio.aws.macie2.model.GetCustomDataIdentifierResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        deleted.map(value => value),
        description.map(value => value),
        id.map(value => value),
        ignoreWords.map(value => value),
        keywords.map(value => value),
        maximumMatchDistance.map(value => value),
        name.map(value => value),
        regex.map(value => value),
        severityLevels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def arn: Optional[__string]
    def createdAt: Optional[__timestampIso8601]
    def deleted: Optional[__boolean]
    def description: Optional[__string]
    def id: Optional[__string]
    def ignoreWords: Optional[List[__string]]
    def keywords: Optional[List[__string]]
    def maximumMatchDistance: Optional[__integer]
    def name: Optional[__string]
    def regex: Optional[__string]
    def severityLevels
        : Optional[List[zio.aws.macie2.model.SeverityLevel.ReadOnly]]
    def tags: Optional[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeleted: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("deleted", deleted)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getIgnoreWords: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("ignoreWords", ignoreWords)
    def getKeywords: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getMaximumMatchDistance: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maximumMatchDistance", maximumMatchDistance)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getRegex: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("regex", regex)
    def getSeverityLevels: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.SeverityLevel.ReadOnly
    ]] = AwsError.unwrapOptionField("severityLevels", severityLevels)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse
  ) extends zio.aws.macie2.model.GetCustomDataIdentifierResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val createdAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __timestampIso8601)
    override val deleted: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleted())
      .map(value => value: __boolean)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val ignoreWords: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.ignoreWords())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val keywords: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.keywords())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val maximumMatchDistance: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumMatchDistance())
        .map(value => value: __integer)
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val regex: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.regex())
      .map(value => value: __string)
    override val severityLevels
        : Optional[List[zio.aws.macie2.model.SeverityLevel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityLevels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.SeverityLevel.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse
  ): zio.aws.macie2.model.GetCustomDataIdentifierResponse.ReadOnly =
    new Wrapper(impl)
}
