package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__string, __timestampIso8601}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetMacieSessionResponse(
    createdAt: Optional[__timestampIso8601] = Optional.Absent,
    findingPublishingFrequency: Optional[
      zio.aws.macie2.model.FindingPublishingFrequency
    ] = Optional.Absent,
    serviceRole: Optional[__string] = Optional.Absent,
    status: Optional[zio.aws.macie2.model.MacieStatus] = Optional.Absent,
    updatedAt: Optional[__timestampIso8601] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse = {
    import GetMacieSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse
      .builder()
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(findingPublishingFrequency.map(value => value.unwrap))(
        _.findingPublishingFrequency
      )
      .optionallyWith(serviceRole.map(value => value: java.lang.String))(
        _.serviceRole
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(updatedAt.map(value => value: Instant))(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetMacieSessionResponse.ReadOnly =
    zio.aws.macie2.model.GetMacieSessionResponse.wrap(buildAwsValue())
}
object GetMacieSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetMacieSessionResponse =
      zio.aws.macie2.model.GetMacieSessionResponse(
        createdAt.map(value => value),
        findingPublishingFrequency.map(value => value),
        serviceRole.map(value => value),
        status.map(value => value),
        updatedAt.map(value => value)
      )
    def createdAt: Optional[__timestampIso8601]
    def findingPublishingFrequency
        : Optional[zio.aws.macie2.model.FindingPublishingFrequency]
    def serviceRole: Optional[__string]
    def status: Optional[zio.aws.macie2.model.MacieStatus]
    def updatedAt: Optional[__timestampIso8601]
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getFindingPublishingFrequency
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingPublishingFrequency] =
      AwsError.unwrapOptionField(
        "findingPublishingFrequency",
        findingPublishingFrequency
      )
    def getServiceRole: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getStatus: ZIO[Any, AwsError, zio.aws.macie2.model.MacieStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUpdatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse
  ) extends zio.aws.macie2.model.GetMacieSessionResponse.ReadOnly {
    override val createdAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __timestampIso8601)
    override val findingPublishingFrequency
        : Optional[zio.aws.macie2.model.FindingPublishingFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingPublishingFrequency())
        .map(value =>
          zio.aws.macie2.model.FindingPublishingFrequency.wrap(value)
        )
    override val serviceRole: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => value: __string)
    override val status: Optional[zio.aws.macie2.model.MacieStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.macie2.model.MacieStatus.wrap(value))
    override val updatedAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse
  ): zio.aws.macie2.model.GetMacieSessionResponse.ReadOnly = new Wrapper(impl)
}
