package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{
  __boolean,
  __integer,
  __timestampIso8601
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetResourceProfileResponse(
    profileUpdatedAt: Optional[__timestampIso8601] = Optional.Absent,
    sensitivityScore: Optional[__integer] = Optional.Absent,
    sensitivityScoreOverridden: Optional[__boolean] = Optional.Absent,
    statistics: Optional[zio.aws.macie2.model.ResourceStatistics] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetResourceProfileResponse = {
    import GetResourceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetResourceProfileResponse
      .builder()
      .optionallyWith(profileUpdatedAt.map(value => value: Instant))(
        _.profileUpdatedAt
      )
      .optionallyWith(sensitivityScore.map(value => value: Integer))(
        _.sensitivityScore
      )
      .optionallyWith(
        sensitivityScoreOverridden.map(value => value: java.lang.Boolean)
      )(_.sensitivityScoreOverridden)
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetResourceProfileResponse.ReadOnly =
    zio.aws.macie2.model.GetResourceProfileResponse.wrap(buildAwsValue())
}
object GetResourceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetResourceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetResourceProfileResponse =
      zio.aws.macie2.model.GetResourceProfileResponse(
        profileUpdatedAt.map(value => value),
        sensitivityScore.map(value => value),
        sensitivityScoreOverridden.map(value => value),
        statistics.map(value => value.asEditable)
      )
    def profileUpdatedAt: Optional[__timestampIso8601]
    def sensitivityScore: Optional[__integer]
    def sensitivityScoreOverridden: Optional[__boolean]
    def statistics: Optional[zio.aws.macie2.model.ResourceStatistics.ReadOnly]
    def getProfileUpdatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("profileUpdatedAt", profileUpdatedAt)
    def getSensitivityScore: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("sensitivityScore", sensitivityScore)
    def getSensitivityScoreOverridden: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField(
        "sensitivityScoreOverridden",
        sensitivityScoreOverridden
      )
    def getStatistics
        : ZIO[Any, AwsError, zio.aws.macie2.model.ResourceStatistics.ReadOnly] =
      AwsError.unwrapOptionField("statistics", statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetResourceProfileResponse
  ) extends zio.aws.macie2.model.GetResourceProfileResponse.ReadOnly {
    override val profileUpdatedAt: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profileUpdatedAt())
        .map(value => value: __timestampIso8601)
    override val sensitivityScore: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitivityScore())
      .map(value => value: __integer)
    override val sensitivityScoreOverridden: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sensitivityScoreOverridden())
        .map(value => value: __boolean)
    override val statistics
        : Optional[zio.aws.macie2.model.ResourceStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value => zio.aws.macie2.model.ResourceStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetResourceProfileResponse
  ): zio.aws.macie2.model.GetResourceProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
