package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{
  SensitivityInspectionTemplateId,
  __string
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSensitivityInspectionTemplateResponse(
    description: Optional[__string] = Optional.Absent,
    excludes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateExcludes
    ] = Optional.Absent,
    includes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateIncludes
    ] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    sensitivityInspectionTemplateId: Optional[SensitivityInspectionTemplateId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetSensitivityInspectionTemplateResponse = {
    import GetSensitivityInspectionTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetSensitivityInspectionTemplateResponse
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(excludes.map(value => value.buildAwsValue()))(_.excludes)
      .optionallyWith(includes.map(value => value.buildAwsValue()))(_.includes)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        sensitivityInspectionTemplateId.map(value =>
          SensitivityInspectionTemplateId.unwrap(value): java.lang.String
        )
      )(_.sensitivityInspectionTemplateId)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.GetSensitivityInspectionTemplateResponse.ReadOnly =
    zio.aws.macie2.model.GetSensitivityInspectionTemplateResponse
      .wrap(buildAwsValue())
}
object GetSensitivityInspectionTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetSensitivityInspectionTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.GetSensitivityInspectionTemplateResponse =
      zio.aws.macie2.model.GetSensitivityInspectionTemplateResponse(
        description.map(value => value),
        excludes.map(value => value.asEditable),
        includes.map(value => value.asEditable),
        name.map(value => value),
        sensitivityInspectionTemplateId.map(value => value)
      )
    def description: Optional[__string]
    def excludes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateExcludes.ReadOnly
    ]
    def includes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateIncludes.ReadOnly
    ]
    def name: Optional[__string]
    def sensitivityInspectionTemplateId
        : Optional[SensitivityInspectionTemplateId]
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getExcludes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SensitivityInspectionTemplateExcludes.ReadOnly
    ] = AwsError.unwrapOptionField("excludes", excludes)
    def getIncludes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SensitivityInspectionTemplateIncludes.ReadOnly
    ] = AwsError.unwrapOptionField("includes", includes)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getSensitivityInspectionTemplateId
        : ZIO[Any, AwsError, SensitivityInspectionTemplateId] =
      AwsError.unwrapOptionField(
        "sensitivityInspectionTemplateId",
        sensitivityInspectionTemplateId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetSensitivityInspectionTemplateResponse
  ) extends zio.aws.macie2.model.GetSensitivityInspectionTemplateResponse.ReadOnly {
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val excludes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateExcludes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.excludes())
      .map(value =>
        zio.aws.macie2.model.SensitivityInspectionTemplateExcludes.wrap(value)
      )
    override val includes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateIncludes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.includes())
      .map(value =>
        zio.aws.macie2.model.SensitivityInspectionTemplateIncludes.wrap(value)
      )
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val sensitivityInspectionTemplateId
        : Optional[SensitivityInspectionTemplateId] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitivityInspectionTemplateId())
      .map(value =>
        zio.aws.macie2.model.primitives.SensitivityInspectionTemplateId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetSensitivityInspectionTemplateResponse
  ): zio.aws.macie2.model.GetSensitivityInspectionTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
