package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait GroupBy {
  def unwrap: software.amazon.awssdk.services.macie2.model.GroupBy
}
object GroupBy {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.GroupBy
  ): zio.aws.macie2.model.GroupBy = value match {
    case software.amazon.awssdk.services.macie2.model.GroupBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.GroupBy.RESOURCES_AFFECTED_S3_BUCKET_NAME =>
      val r = `resourcesAffected.s3Bucket.name`
      r
    case software.amazon.awssdk.services.macie2.model.GroupBy.TYPE =>
      val r = `type`
      r
    case software.amazon.awssdk.services.macie2.model.GroupBy.CLASSIFICATION_DETAILS_JOB_ID =>
      val r = `classificationDetails.jobId`
      r
    case software.amazon.awssdk.services.macie2.model.GroupBy.SEVERITY_DESCRIPTION =>
      val r = `severity.description`
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.GroupBy {
    override def unwrap: software.amazon.awssdk.services.macie2.model.GroupBy =
      software.amazon.awssdk.services.macie2.model.GroupBy.UNKNOWN_TO_SDK_VERSION
  }
  case object `resourcesAffected.s3Bucket.name`
      extends zio.aws.macie2.model.GroupBy {
    override def unwrap: software.amazon.awssdk.services.macie2.model.GroupBy =
      software.amazon.awssdk.services.macie2.model.GroupBy.RESOURCES_AFFECTED_S3_BUCKET_NAME
  }
  case object `type` extends zio.aws.macie2.model.GroupBy {
    override def unwrap: software.amazon.awssdk.services.macie2.model.GroupBy =
      software.amazon.awssdk.services.macie2.model.GroupBy.TYPE
  }
  case object `classificationDetails.jobId`
      extends zio.aws.macie2.model.GroupBy {
    override def unwrap: software.amazon.awssdk.services.macie2.model.GroupBy =
      software.amazon.awssdk.services.macie2.model.GroupBy.CLASSIFICATION_DETAILS_JOB_ID
  }
  case object `severity.description` extends zio.aws.macie2.model.GroupBy {
    override def unwrap: software.amazon.awssdk.services.macie2.model.GroupBy =
      software.amazon.awssdk.services.macie2.model.GroupBy.SEVERITY_DESCRIPTION
  }
}
