package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IpAddressDetails(
    ipAddressV4: Optional[__string] = Optional.Absent,
    ipCity: Optional[zio.aws.macie2.model.IpCity] = Optional.Absent,
    ipCountry: Optional[zio.aws.macie2.model.IpCountry] = Optional.Absent,
    ipGeoLocation: Optional[zio.aws.macie2.model.IpGeoLocation] =
      Optional.Absent,
    ipOwner: Optional[zio.aws.macie2.model.IpOwner] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.IpAddressDetails = {
    import IpAddressDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.IpAddressDetails
      .builder()
      .optionallyWith(ipAddressV4.map(value => value: java.lang.String))(
        _.ipAddressV4
      )
      .optionallyWith(ipCity.map(value => value.buildAwsValue()))(_.ipCity)
      .optionallyWith(ipCountry.map(value => value.buildAwsValue()))(
        _.ipCountry
      )
      .optionallyWith(ipGeoLocation.map(value => value.buildAwsValue()))(
        _.ipGeoLocation
      )
      .optionallyWith(ipOwner.map(value => value.buildAwsValue()))(_.ipOwner)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.IpAddressDetails.ReadOnly =
    zio.aws.macie2.model.IpAddressDetails.wrap(buildAwsValue())
}
object IpAddressDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.IpAddressDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.IpAddressDetails =
      zio.aws.macie2.model.IpAddressDetails(
        ipAddressV4.map(value => value),
        ipCity.map(value => value.asEditable),
        ipCountry.map(value => value.asEditable),
        ipGeoLocation.map(value => value.asEditable),
        ipOwner.map(value => value.asEditable)
      )
    def ipAddressV4: Optional[__string]
    def ipCity: Optional[zio.aws.macie2.model.IpCity.ReadOnly]
    def ipCountry: Optional[zio.aws.macie2.model.IpCountry.ReadOnly]
    def ipGeoLocation: Optional[zio.aws.macie2.model.IpGeoLocation.ReadOnly]
    def ipOwner: Optional[zio.aws.macie2.model.IpOwner.ReadOnly]
    def getIpAddressV4: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("ipAddressV4", ipAddressV4)
    def getIpCity: ZIO[Any, AwsError, zio.aws.macie2.model.IpCity.ReadOnly] =
      AwsError.unwrapOptionField("ipCity", ipCity)
    def getIpCountry
        : ZIO[Any, AwsError, zio.aws.macie2.model.IpCountry.ReadOnly] =
      AwsError.unwrapOptionField("ipCountry", ipCountry)
    def getIpGeoLocation
        : ZIO[Any, AwsError, zio.aws.macie2.model.IpGeoLocation.ReadOnly] =
      AwsError.unwrapOptionField("ipGeoLocation", ipGeoLocation)
    def getIpOwner: ZIO[Any, AwsError, zio.aws.macie2.model.IpOwner.ReadOnly] =
      AwsError.unwrapOptionField("ipOwner", ipOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.IpAddressDetails
  ) extends zio.aws.macie2.model.IpAddressDetails.ReadOnly {
    override val ipAddressV4: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddressV4())
      .map(value => value: __string)
    override val ipCity: Optional[zio.aws.macie2.model.IpCity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipCity())
        .map(value => zio.aws.macie2.model.IpCity.wrap(value))
    override val ipCountry: Optional[zio.aws.macie2.model.IpCountry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipCountry())
        .map(value => zio.aws.macie2.model.IpCountry.wrap(value))
    override val ipGeoLocation
        : Optional[zio.aws.macie2.model.IpGeoLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipGeoLocation())
        .map(value => zio.aws.macie2.model.IpGeoLocation.wrap(value))
    override val ipOwner: Optional[zio.aws.macie2.model.IpOwner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipOwner())
        .map(value => zio.aws.macie2.model.IpOwner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.IpAddressDetails
  ): zio.aws.macie2.model.IpAddressDetails.ReadOnly = new Wrapper(impl)
}
