package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait IsMonitoredByJob {
  def unwrap: software.amazon.awssdk.services.macie2.model.IsMonitoredByJob
}
object IsMonitoredByJob {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.IsMonitoredByJob
  ): zio.aws.macie2.model.IsMonitoredByJob = value match {
    case software.amazon.awssdk.services.macie2.model.IsMonitoredByJob.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.IsMonitoredByJob.TRUE =>
      val r = TRUE
      r
    case software.amazon.awssdk.services.macie2.model.IsMonitoredByJob.FALSE =>
      val r = FALSE
      r
    case software.amazon.awssdk.services.macie2.model.IsMonitoredByJob.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.IsMonitoredByJob {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.IsMonitoredByJob =
      software.amazon.awssdk.services.macie2.model.IsMonitoredByJob.UNKNOWN_TO_SDK_VERSION
  }
  case object TRUE extends zio.aws.macie2.model.IsMonitoredByJob {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.IsMonitoredByJob =
      software.amazon.awssdk.services.macie2.model.IsMonitoredByJob.TRUE
  }
  case object FALSE extends zio.aws.macie2.model.IsMonitoredByJob {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.IsMonitoredByJob =
      software.amazon.awssdk.services.macie2.model.IsMonitoredByJob.FALSE
  }
  case object UNKNOWN extends zio.aws.macie2.model.IsMonitoredByJob {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.IsMonitoredByJob =
      software.amazon.awssdk.services.macie2.model.IsMonitoredByJob.UNKNOWN
  }
}
