package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LastRunErrorStatus(
    code: Optional[zio.aws.macie2.model.LastRunErrorStatusCode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.LastRunErrorStatus = {
    import LastRunErrorStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.LastRunErrorStatus
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.LastRunErrorStatus.ReadOnly =
    zio.aws.macie2.model.LastRunErrorStatus.wrap(buildAwsValue())
}
object LastRunErrorStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.LastRunErrorStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.LastRunErrorStatus =
      zio.aws.macie2.model.LastRunErrorStatus(code.map(value => value))
    def code: Optional[zio.aws.macie2.model.LastRunErrorStatusCode]
    def getCode
        : ZIO[Any, AwsError, zio.aws.macie2.model.LastRunErrorStatusCode] =
      AwsError.unwrapOptionField("code", code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.LastRunErrorStatus
  ) extends zio.aws.macie2.model.LastRunErrorStatus.ReadOnly {
    override val code: Optional[zio.aws.macie2.model.LastRunErrorStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.macie2.model.LastRunErrorStatusCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.LastRunErrorStatus
  ): zio.aws.macie2.model.LastRunErrorStatus.ReadOnly = new Wrapper(impl)
}
