package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{MaxResults, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAutomatedDiscoveryAccountsRequest(
    accountIds: Optional[Iterable[__string]] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListAutomatedDiscoveryAccountsRequest = {
    import ListAutomatedDiscoveryAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListAutomatedDiscoveryAccountsRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListAutomatedDiscoveryAccountsRequest.ReadOnly =
    zio.aws.macie2.model.ListAutomatedDiscoveryAccountsRequest
      .wrap(buildAwsValue())
}
object ListAutomatedDiscoveryAccountsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListAutomatedDiscoveryAccountsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListAutomatedDiscoveryAccountsRequest =
      zio.aws.macie2.model.ListAutomatedDiscoveryAccountsRequest(
        accountIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def accountIds: Optional[List[__string]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getAccountIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListAutomatedDiscoveryAccountsRequest
  ) extends zio.aws.macie2.model.ListAutomatedDiscoveryAccountsRequest.ReadOnly {
    override val accountIds: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.macie2.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListAutomatedDiscoveryAccountsRequest
  ): zio.aws.macie2.model.ListAutomatedDiscoveryAccountsRequest.ReadOnly =
    new Wrapper(impl)
}
