package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListClassificationScopesRequest(
    name: Optional[__string] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListClassificationScopesRequest = {
    import ListClassificationScopesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListClassificationScopesRequest
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListClassificationScopesRequest.ReadOnly =
    zio.aws.macie2.model.ListClassificationScopesRequest.wrap(buildAwsValue())
}
object ListClassificationScopesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListClassificationScopesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListClassificationScopesRequest =
      zio.aws.macie2.model.ListClassificationScopesRequest(
        name.map(value => value),
        nextToken.map(value => value)
      )
    def name: Optional[__string]
    def nextToken: Optional[__string]
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListClassificationScopesRequest
  ) extends zio.aws.macie2.model.ListClassificationScopesRequest.ReadOnly {
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListClassificationScopesRequest
  ): zio.aws.macie2.model.ListClassificationScopesRequest.ReadOnly =
    new Wrapper(impl)
}
