package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListClassificationScopesResponse(
    classificationScopes: Optional[
      Iterable[zio.aws.macie2.model.ClassificationScopeSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListClassificationScopesResponse = {
    import ListClassificationScopesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListClassificationScopesResponse
      .builder()
      .optionallyWith(
        classificationScopes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.classificationScopes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListClassificationScopesResponse.ReadOnly =
    zio.aws.macie2.model.ListClassificationScopesResponse.wrap(buildAwsValue())
}
object ListClassificationScopesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListClassificationScopesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListClassificationScopesResponse =
      zio.aws.macie2.model.ListClassificationScopesResponse(
        classificationScopes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def classificationScopes: Optional[
      List[zio.aws.macie2.model.ClassificationScopeSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getClassificationScopes: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.ClassificationScopeSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("classificationScopes", classificationScopes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListClassificationScopesResponse
  ) extends zio.aws.macie2.model.ListClassificationScopesResponse.ReadOnly {
    override val classificationScopes: Optional[
      List[zio.aws.macie2.model.ClassificationScopeSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.classificationScopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.ClassificationScopeSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.macie2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListClassificationScopesResponse
  ): zio.aws.macie2.model.ListClassificationScopesResponse.ReadOnly =
    new Wrapper(impl)
}
