package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFindingsResponse(
    findingIds: Optional[Iterable[__string]] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListFindingsResponse = {
    import ListFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListFindingsResponse
      .builder()
      .optionallyWith(
        findingIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.findingIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListFindingsResponse.ReadOnly =
    zio.aws.macie2.model.ListFindingsResponse.wrap(buildAwsValue())
}
object ListFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListFindingsResponse =
      zio.aws.macie2.model.ListFindingsResponse(
        findingIds.map(value => value),
        nextToken.map(value => value)
      )
    def findingIds: Optional[List[__string]]
    def nextToken: Optional[__string]
    def getFindingIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("findingIds", findingIds)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListFindingsResponse
  ) extends zio.aws.macie2.model.ListFindingsResponse.ReadOnly {
    override val findingIds: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.findingIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListFindingsResponse
  ): zio.aws.macie2.model.ListFindingsResponse.ReadOnly = new Wrapper(impl)
}
