package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait ListJobsFilterKey {
  def unwrap: software.amazon.awssdk.services.macie2.model.ListJobsFilterKey
}
object ListJobsFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.ListJobsFilterKey
  ): zio.aws.macie2.model.ListJobsFilterKey = value match {
    case software.amazon.awssdk.services.macie2.model.ListJobsFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.ListJobsFilterKey.JOB_TYPE =>
      val r = jobType
      r
    case software.amazon.awssdk.services.macie2.model.ListJobsFilterKey.JOB_STATUS =>
      val r = jobStatus
      r
    case software.amazon.awssdk.services.macie2.model.ListJobsFilterKey.CREATED_AT =>
      val r = createdAt
      r
    case software.amazon.awssdk.services.macie2.model.ListJobsFilterKey.NAME =>
      val r = name
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.ListJobsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ListJobsFilterKey =
      software.amazon.awssdk.services.macie2.model.ListJobsFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object jobType extends zio.aws.macie2.model.ListJobsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ListJobsFilterKey =
      software.amazon.awssdk.services.macie2.model.ListJobsFilterKey.JOB_TYPE
  }
  case object jobStatus extends zio.aws.macie2.model.ListJobsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ListJobsFilterKey =
      software.amazon.awssdk.services.macie2.model.ListJobsFilterKey.JOB_STATUS
  }
  case object createdAt extends zio.aws.macie2.model.ListJobsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ListJobsFilterKey =
      software.amazon.awssdk.services.macie2.model.ListJobsFilterKey.CREATED_AT
  }
  case object name extends zio.aws.macie2.model.ListJobsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ListJobsFilterKey =
      software.amazon.awssdk.services.macie2.model.ListJobsFilterKey.NAME
  }
}
