package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListManagedDataIdentifiersRequest(
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest = {
    import ListManagedDataIdentifiersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListManagedDataIdentifiersRequest.ReadOnly =
    zio.aws.macie2.model.ListManagedDataIdentifiersRequest.wrap(buildAwsValue())
}
object ListManagedDataIdentifiersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListManagedDataIdentifiersRequest =
      zio.aws.macie2.model
        .ListManagedDataIdentifiersRequest(nextToken.map(value => value))
    def nextToken: Optional[__string]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest
  ) extends zio.aws.macie2.model.ListManagedDataIdentifiersRequest.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest
  ): zio.aws.macie2.model.ListManagedDataIdentifiersRequest.ReadOnly =
    new Wrapper(impl)
}
