package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListMembersResponse(
    members: Optional[Iterable[zio.aws.macie2.model.Member]] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListMembersResponse = {
    import ListMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListMembersResponse
      .builder()
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListMembersResponse.ReadOnly =
    zio.aws.macie2.model.ListMembersResponse.wrap(buildAwsValue())
}
object ListMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListMembersResponse =
      zio.aws.macie2.model.ListMembersResponse(
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def members: Optional[List[zio.aws.macie2.model.Member.ReadOnly]]
    def nextToken: Optional[__string]
    def getMembers
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.Member.ReadOnly]] =
      AwsError.unwrapOptionField("members", members)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListMembersResponse
  ) extends zio.aws.macie2.model.ListMembersResponse.ReadOnly {
    override val members: Optional[List[zio.aws.macie2.model.Member.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.members())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.Member.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListMembersResponse
  ): zio.aws.macie2.model.ListMembersResponse.ReadOnly = new Wrapper(impl)
}
