package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__string, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListResourceProfileDetectionsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    resourceArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsRequest = {
    import ListResourceProfileDetectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .resourceArn(resourceArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListResourceProfileDetectionsRequest.ReadOnly =
    zio.aws.macie2.model.ListResourceProfileDetectionsRequest
      .wrap(buildAwsValue())
}
object ListResourceProfileDetectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListResourceProfileDetectionsRequest =
      zio.aws.macie2.model.ListResourceProfileDetectionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceArn
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def resourceArn: __string
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsRequest
  ) extends zio.aws.macie2.model.ListResourceProfileDetectionsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.macie2.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val resourceArn: __string = impl.resourceArn(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsRequest
  ): zio.aws.macie2.model.ListResourceProfileDetectionsRequest.ReadOnly =
    new Wrapper(impl)
}
