package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutFindingsPublicationConfigurationRequest(
    clientToken: Optional[__string] = Optional.Absent,
    securityHubConfiguration: Optional[
      zio.aws.macie2.model.SecurityHubConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.PutFindingsPublicationConfigurationRequest = {
    import PutFindingsPublicationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.PutFindingsPublicationConfigurationRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        securityHubConfiguration.map(value => value.buildAwsValue())
      )(_.securityHubConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.PutFindingsPublicationConfigurationRequest.ReadOnly =
    zio.aws.macie2.model.PutFindingsPublicationConfigurationRequest
      .wrap(buildAwsValue())
}
object PutFindingsPublicationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.PutFindingsPublicationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.PutFindingsPublicationConfigurationRequest =
      zio.aws.macie2.model.PutFindingsPublicationConfigurationRequest(
        clientToken.map(value => value),
        securityHubConfiguration.map(value => value.asEditable)
      )
    def clientToken: Optional[__string]
    def securityHubConfiguration
        : Optional[zio.aws.macie2.model.SecurityHubConfiguration.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSecurityHubConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SecurityHubConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "securityHubConfiguration",
      securityHubConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.PutFindingsPublicationConfigurationRequest
  ) extends zio.aws.macie2.model.PutFindingsPublicationConfigurationRequest.ReadOnly {
    override val clientToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: __string)
    override val securityHubConfiguration
        : Optional[zio.aws.macie2.model.SecurityHubConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityHubConfiguration())
        .map(value => zio.aws.macie2.model.SecurityHubConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.PutFindingsPublicationConfigurationRequest
  ): zio.aws.macie2.model.PutFindingsPublicationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
