package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__stringMin1Max64PatternW, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RetrievalConfiguration(
    externalId: Optional[__string] = Optional.Absent,
    retrievalMode: zio.aws.macie2.model.RetrievalMode,
    roleName: Optional[__stringMin1Max64PatternW] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.RetrievalConfiguration = {
    import RetrievalConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.RetrievalConfiguration
      .builder()
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .retrievalMode(retrievalMode.unwrap)
      .optionallyWith(roleName.map(value => value: java.lang.String))(
        _.roleName
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.RetrievalConfiguration.ReadOnly =
    zio.aws.macie2.model.RetrievalConfiguration.wrap(buildAwsValue())
}
object RetrievalConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.RetrievalConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.RetrievalConfiguration =
      zio.aws.macie2.model.RetrievalConfiguration(
        externalId.map(value => value),
        retrievalMode,
        roleName.map(value => value)
      )
    def externalId: Optional[__string]
    def retrievalMode: zio.aws.macie2.model.RetrievalMode
    def roleName: Optional[__stringMin1Max64PatternW]
    def getExternalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getRetrievalMode
        : ZIO[Any, Nothing, zio.aws.macie2.model.RetrievalMode] =
      ZIO.succeed(retrievalMode)
    def getRoleName: ZIO[Any, AwsError, __stringMin1Max64PatternW] =
      AwsError.unwrapOptionField("roleName", roleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.RetrievalConfiguration
  ) extends zio.aws.macie2.model.RetrievalConfiguration.ReadOnly {
    override val externalId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => value: __string)
    override val retrievalMode: zio.aws.macie2.model.RetrievalMode =
      zio.aws.macie2.model.RetrievalMode.wrap(impl.retrievalMode())
    override val roleName: Optional[__stringMin1Max64PatternW] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roleName())
        .map(value => value: __stringMin1Max64PatternW)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.RetrievalConfiguration
  ): zio.aws.macie2.model.RetrievalConfiguration.ReadOnly = new Wrapper(impl)
}
