package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait RetrievalMode {
  def unwrap: software.amazon.awssdk.services.macie2.model.RetrievalMode
}
object RetrievalMode {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.RetrievalMode
  ): zio.aws.macie2.model.RetrievalMode = value match {
    case software.amazon.awssdk.services.macie2.model.RetrievalMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.RetrievalMode.CALLER_CREDENTIALS =>
      val r = CALLER_CREDENTIALS
      r
    case software.amazon.awssdk.services.macie2.model.RetrievalMode.ASSUME_ROLE =>
      val r = ASSUME_ROLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.RetrievalMode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RetrievalMode =
      software.amazon.awssdk.services.macie2.model.RetrievalMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CALLER_CREDENTIALS extends zio.aws.macie2.model.RetrievalMode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RetrievalMode =
      software.amazon.awssdk.services.macie2.model.RetrievalMode.CALLER_CREDENTIALS
  }
  case object ASSUME_ROLE extends zio.aws.macie2.model.RetrievalMode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RetrievalMode =
      software.amazon.awssdk.services.macie2.model.RetrievalMode.ASSUME_ROLE
  }
}
