package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3ClassificationScopeUpdate(
    excludes: zio.aws.macie2.model.S3ClassificationScopeExclusionUpdate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.S3ClassificationScopeUpdate = {
    import S3ClassificationScopeUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3ClassificationScopeUpdate
      .builder()
      .excludes(excludes.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3ClassificationScopeUpdate.ReadOnly =
    zio.aws.macie2.model.S3ClassificationScopeUpdate.wrap(buildAwsValue())
}
object S3ClassificationScopeUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.S3ClassificationScopeUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3ClassificationScopeUpdate =
      zio.aws.macie2.model.S3ClassificationScopeUpdate(excludes.asEditable)
    def excludes
        : zio.aws.macie2.model.S3ClassificationScopeExclusionUpdate.ReadOnly
    def getExcludes: ZIO[
      Any,
      Nothing,
      zio.aws.macie2.model.S3ClassificationScopeExclusionUpdate.ReadOnly
    ] = ZIO.succeed(excludes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3ClassificationScopeUpdate
  ) extends zio.aws.macie2.model.S3ClassificationScopeUpdate.ReadOnly {
    override val excludes
        : zio.aws.macie2.model.S3ClassificationScopeExclusionUpdate.ReadOnly =
      zio.aws.macie2.model.S3ClassificationScopeExclusionUpdate
        .wrap(impl.excludes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3ClassificationScopeUpdate
  ): zio.aws.macie2.model.S3ClassificationScopeUpdate.ReadOnly = new Wrapper(
    impl
  )
}
