package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SensitivityInspectionTemplatesEntry(
    id: Optional[__string] = Optional.Absent,
    name: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry = {
    import SensitivityInspectionTemplatesEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.SensitivityInspectionTemplatesEntry.ReadOnly =
    zio.aws.macie2.model.SensitivityInspectionTemplatesEntry
      .wrap(buildAwsValue())
}
object SensitivityInspectionTemplatesEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SensitivityInspectionTemplatesEntry =
      zio.aws.macie2.model.SensitivityInspectionTemplatesEntry(
        id.map(value => value),
        name.map(value => value)
      )
    def id: Optional[__string]
    def name: Optional[__string]
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry
  ) extends zio.aws.macie2.model.SensitivityInspectionTemplatesEntry.ReadOnly {
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry
  ): zio.aws.macie2.model.SensitivityInspectionTemplatesEntry.ReadOnly =
    new Wrapper(impl)
}
