package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait UnavailabilityReasonCode {
  def unwrap
      : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode
}
object UnavailabilityReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode
  ): zio.aws.macie2.model.UnavailabilityReasonCode = value match {
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.OBJECT_EXCEEDS_SIZE_QUOTA =>
      val r = OBJECT_EXCEEDS_SIZE_QUOTA
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNSUPPORTED_OBJECT_TYPE =>
      val r = UNSUPPORTED_OBJECT_TYPE
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNSUPPORTED_FINDING_TYPE =>
      val r = UNSUPPORTED_FINDING_TYPE
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.INVALID_CLASSIFICATION_RESULT =>
      val r = INVALID_CLASSIFICATION_RESULT
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.OBJECT_UNAVAILABLE =>
      val r = OBJECT_UNAVAILABLE
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.ACCOUNT_NOT_IN_ORGANIZATION =>
      val r = ACCOUNT_NOT_IN_ORGANIZATION
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.MISSING_GET_MEMBER_PERMISSION =>
      val r = MISSING_GET_MEMBER_PERMISSION
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.ROLE_TOO_PERMISSIVE =>
      val r = ROLE_TOO_PERMISSIVE
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.MEMBER_ROLE_TOO_PERMISSIVE =>
      val r = MEMBER_ROLE_TOO_PERMISSIVE
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.INVALID_RESULT_SIGNATURE =>
      val r = INVALID_RESULT_SIGNATURE
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.RESULT_NOT_SIGNED =>
      val r = RESULT_NOT_SIGNED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object OBJECT_EXCEEDS_SIZE_QUOTA
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.OBJECT_EXCEEDS_SIZE_QUOTA
  }
  case object UNSUPPORTED_OBJECT_TYPE
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNSUPPORTED_OBJECT_TYPE
  }
  case object UNSUPPORTED_FINDING_TYPE
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNSUPPORTED_FINDING_TYPE
  }
  case object INVALID_CLASSIFICATION_RESULT
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.INVALID_CLASSIFICATION_RESULT
  }
  case object OBJECT_UNAVAILABLE
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.OBJECT_UNAVAILABLE
  }
  case object ACCOUNT_NOT_IN_ORGANIZATION
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.ACCOUNT_NOT_IN_ORGANIZATION
  }
  case object MISSING_GET_MEMBER_PERMISSION
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.MISSING_GET_MEMBER_PERMISSION
  }
  case object ROLE_TOO_PERMISSIVE
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.ROLE_TOO_PERMISSIVE
  }
  case object MEMBER_ROLE_TOO_PERMISSIVE
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.MEMBER_ROLE_TOO_PERMISSIVE
  }
  case object INVALID_RESULT_SIGNATURE
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.INVALID_RESULT_SIGNATURE
  }
  case object RESULT_NOT_SIGNED
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.RESULT_NOT_SIGNED
  }
}
