package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait Unit {
  def unwrap: software.amazon.awssdk.services.macie2.model.Unit
}
object Unit {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.Unit
  ): zio.aws.macie2.model.Unit = value match {
    case software.amazon.awssdk.services.macie2.model.Unit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.Unit.TERABYTES =>
      val r = TERABYTES
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.Unit {
    override def unwrap: software.amazon.awssdk.services.macie2.model.Unit =
      software.amazon.awssdk.services.macie2.model.Unit.UNKNOWN_TO_SDK_VERSION
  }
  case object TERABYTES extends zio.aws.macie2.model.Unit {
    override def unwrap: software.amazon.awssdk.services.macie2.model.Unit =
      software.amazon.awssdk.services.macie2.model.Unit.TERABYTES
  }
}
