package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAutomatedDiscoveryConfigurationRequest(
    autoEnableOrganizationMembers: Optional[
      zio.aws.macie2.model.AutoEnableMode
    ] = Optional.Absent,
    status: zio.aws.macie2.model.AutomatedDiscoveryStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest = {
    import UpdateAutomatedDiscoveryConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest
      .builder()
      .optionallyWith(autoEnableOrganizationMembers.map(value => value.unwrap))(
        _.autoEnableOrganizationMembers
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest.ReadOnly =
    zio.aws.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateAutomatedDiscoveryConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest =
      zio.aws.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest(
        autoEnableOrganizationMembers.map(value => value),
        status
      )
    def autoEnableOrganizationMembers
        : Optional[zio.aws.macie2.model.AutoEnableMode]
    def status: zio.aws.macie2.model.AutomatedDiscoveryStatus
    def getAutoEnableOrganizationMembers
        : ZIO[Any, AwsError, zio.aws.macie2.model.AutoEnableMode] =
      AwsError.unwrapOptionField(
        "autoEnableOrganizationMembers",
        autoEnableOrganizationMembers
      )
    def getStatus
        : ZIO[Any, Nothing, zio.aws.macie2.model.AutomatedDiscoveryStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest
  ) extends zio.aws.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest.ReadOnly {
    override val autoEnableOrganizationMembers
        : Optional[zio.aws.macie2.model.AutoEnableMode] = zio.aws.core.internal
      .optionalFromNullable(impl.autoEnableOrganizationMembers())
      .map(value => zio.aws.macie2.model.AutoEnableMode.wrap(value))
    override val status: zio.aws.macie2.model.AutomatedDiscoveryStatus =
      zio.aws.macie2.model.AutomatedDiscoveryStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest
  ): zio.aws.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
