package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__stringMin1Max64PatternW
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateRetrievalConfiguration(
    retrievalMode: zio.aws.macie2.model.RetrievalMode,
    roleName: Optional[__stringMin1Max64PatternW] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateRetrievalConfiguration = {
    import UpdateRetrievalConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateRetrievalConfiguration
      .builder()
      .retrievalMode(retrievalMode.unwrap)
      .optionallyWith(roleName.map(value => value: java.lang.String))(
        _.roleName
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UpdateRetrievalConfiguration.ReadOnly =
    zio.aws.macie2.model.UpdateRetrievalConfiguration.wrap(buildAwsValue())
}
object UpdateRetrievalConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateRetrievalConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UpdateRetrievalConfiguration =
      zio.aws.macie2.model.UpdateRetrievalConfiguration(
        retrievalMode,
        roleName.map(value => value)
      )
    def retrievalMode: zio.aws.macie2.model.RetrievalMode
    def roleName: Optional[__stringMin1Max64PatternW]
    def getRetrievalMode
        : ZIO[Any, Nothing, zio.aws.macie2.model.RetrievalMode] =
      ZIO.succeed(retrievalMode)
    def getRoleName: ZIO[Any, AwsError, __stringMin1Max64PatternW] =
      AwsError.unwrapOptionField("roleName", roleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateRetrievalConfiguration
  ) extends zio.aws.macie2.model.UpdateRetrievalConfiguration.ReadOnly {
    override val retrievalMode: zio.aws.macie2.model.RetrievalMode =
      zio.aws.macie2.model.RetrievalMode.wrap(impl.retrievalMode())
    override val roleName: Optional[__stringMin1Max64PatternW] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roleName())
        .map(value => value: __stringMin1Max64PatternW)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateRetrievalConfiguration
  ): zio.aws.macie2.model.UpdateRetrievalConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
