package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateRevealConfigurationRequest(
    configuration: zio.aws.macie2.model.RevealConfiguration,
    retrievalConfiguration: Optional[
      zio.aws.macie2.model.UpdateRetrievalConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest = {
    import UpdateRevealConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest
      .builder()
      .configuration(configuration.buildAwsValue())
      .optionallyWith(
        retrievalConfiguration.map(value => value.buildAwsValue())
      )(_.retrievalConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.UpdateRevealConfigurationRequest.ReadOnly =
    zio.aws.macie2.model.UpdateRevealConfigurationRequest.wrap(buildAwsValue())
}
object UpdateRevealConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UpdateRevealConfigurationRequest =
      zio.aws.macie2.model.UpdateRevealConfigurationRequest(
        configuration.asEditable,
        retrievalConfiguration.map(value => value.asEditable)
      )
    def configuration: zio.aws.macie2.model.RevealConfiguration.ReadOnly
    def retrievalConfiguration
        : Optional[zio.aws.macie2.model.UpdateRetrievalConfiguration.ReadOnly]
    def getConfiguration
        : ZIO[Any, Nothing, zio.aws.macie2.model.RevealConfiguration.ReadOnly] =
      ZIO.succeed(configuration)
    def getRetrievalConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.UpdateRetrievalConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "retrievalConfiguration",
      retrievalConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest
  ) extends zio.aws.macie2.model.UpdateRevealConfigurationRequest.ReadOnly {
    override val configuration
        : zio.aws.macie2.model.RevealConfiguration.ReadOnly =
      zio.aws.macie2.model.RevealConfiguration.wrap(impl.configuration())
    override val retrievalConfiguration
        : Optional[zio.aws.macie2.model.UpdateRetrievalConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retrievalConfiguration())
        .map(value =>
          zio.aws.macie2.model.UpdateRetrievalConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest
  ): zio.aws.macie2.model.UpdateRevealConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
