package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateRevealConfigurationResponse(
    configuration: Optional[zio.aws.macie2.model.RevealConfiguration] =
      Optional.Absent,
    retrievalConfiguration: Optional[
      zio.aws.macie2.model.RetrievalConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationResponse = {
    import UpdateRevealConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationResponse
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        retrievalConfiguration.map(value => value.buildAwsValue())
      )(_.retrievalConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.UpdateRevealConfigurationResponse.ReadOnly =
    zio.aws.macie2.model.UpdateRevealConfigurationResponse.wrap(buildAwsValue())
}
object UpdateRevealConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UpdateRevealConfigurationResponse =
      zio.aws.macie2.model.UpdateRevealConfigurationResponse(
        configuration.map(value => value.asEditable),
        retrievalConfiguration.map(value => value.asEditable)
      )
    def configuration
        : Optional[zio.aws.macie2.model.RevealConfiguration.ReadOnly]
    def retrievalConfiguration
        : Optional[zio.aws.macie2.model.RetrievalConfiguration.ReadOnly]
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.RevealConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getRetrievalConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.RetrievalConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "retrievalConfiguration",
      retrievalConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationResponse
  ) extends zio.aws.macie2.model.UpdateRevealConfigurationResponse.ReadOnly {
    override val configuration
        : Optional[zio.aws.macie2.model.RevealConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.macie2.model.RevealConfiguration.wrap(value))
    override val retrievalConfiguration
        : Optional[zio.aws.macie2.model.RetrievalConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retrievalConfiguration())
        .map(value => zio.aws.macie2.model.RetrievalConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationResponse
  ): zio.aws.macie2.model.UpdateRevealConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
