package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSensitivityInspectionTemplateRequest(
    description: Optional[__string] = Optional.Absent,
    excludes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateExcludes
    ] = Optional.Absent,
    id: __string,
    includes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateIncludes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateSensitivityInspectionTemplateRequest = {
    import UpdateSensitivityInspectionTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateSensitivityInspectionTemplateRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(excludes.map(value => value.buildAwsValue()))(_.excludes)
      .id(id: java.lang.String)
      .optionallyWith(includes.map(value => value.buildAwsValue()))(_.includes)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.UpdateSensitivityInspectionTemplateRequest.ReadOnly =
    zio.aws.macie2.model.UpdateSensitivityInspectionTemplateRequest
      .wrap(buildAwsValue())
}
object UpdateSensitivityInspectionTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateSensitivityInspectionTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.UpdateSensitivityInspectionTemplateRequest =
      zio.aws.macie2.model.UpdateSensitivityInspectionTemplateRequest(
        description.map(value => value),
        excludes.map(value => value.asEditable),
        id,
        includes.map(value => value.asEditable)
      )
    def description: Optional[__string]
    def excludes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateExcludes.ReadOnly
    ]
    def id: __string
    def includes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateIncludes.ReadOnly
    ]
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getExcludes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SensitivityInspectionTemplateExcludes.ReadOnly
    ] = AwsError.unwrapOptionField("excludes", excludes)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getIncludes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SensitivityInspectionTemplateIncludes.ReadOnly
    ] = AwsError.unwrapOptionField("includes", includes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateSensitivityInspectionTemplateRequest
  ) extends zio.aws.macie2.model.UpdateSensitivityInspectionTemplateRequest.ReadOnly {
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val excludes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateExcludes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.excludes())
      .map(value =>
        zio.aws.macie2.model.SensitivityInspectionTemplateExcludes.wrap(value)
      )
    override val id: __string = impl.id(): __string
    override val includes: Optional[
      zio.aws.macie2.model.SensitivityInspectionTemplateIncludes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.includes())
      .map(value =>
        zio.aws.macie2.model.SensitivityInspectionTemplateIncludes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateSensitivityInspectionTemplateRequest
  ): zio.aws.macie2.model.UpdateSensitivityInspectionTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
