package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait UserIdentityType {
  def unwrap: software.amazon.awssdk.services.macie2.model.UserIdentityType
}
object UserIdentityType {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.UserIdentityType
  ): zio.aws.macie2.model.UserIdentityType = value match {
    case software.amazon.awssdk.services.macie2.model.UserIdentityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.UserIdentityType.ASSUMED_ROLE =>
      val r = AssumedRole
      r
    case software.amazon.awssdk.services.macie2.model.UserIdentityType.IAM_USER =>
      val r = IAMUser
      r
    case software.amazon.awssdk.services.macie2.model.UserIdentityType.FEDERATED_USER =>
      val r = FederatedUser
      r
    case software.amazon.awssdk.services.macie2.model.UserIdentityType.ROOT =>
      val r = Root
      r
    case software.amazon.awssdk.services.macie2.model.UserIdentityType.AWS_ACCOUNT =>
      val r = AWSAccount
      r
    case software.amazon.awssdk.services.macie2.model.UserIdentityType.AWS_SERVICE =>
      val r = AWSService
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.UserIdentityType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UserIdentityType =
      software.amazon.awssdk.services.macie2.model.UserIdentityType.UNKNOWN_TO_SDK_VERSION
  }
  case object AssumedRole extends zio.aws.macie2.model.UserIdentityType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UserIdentityType =
      software.amazon.awssdk.services.macie2.model.UserIdentityType.ASSUMED_ROLE
  }
  case object IAMUser extends zio.aws.macie2.model.UserIdentityType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UserIdentityType =
      software.amazon.awssdk.services.macie2.model.UserIdentityType.IAM_USER
  }
  case object FederatedUser extends zio.aws.macie2.model.UserIdentityType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UserIdentityType =
      software.amazon.awssdk.services.macie2.model.UserIdentityType.FEDERATED_USER
  }
  case object Root extends zio.aws.macie2.model.UserIdentityType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UserIdentityType =
      software.amazon.awssdk.services.macie2.model.UserIdentityType.ROOT
  }
  case object AWSAccount extends zio.aws.macie2.model.UserIdentityType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UserIdentityType =
      software.amazon.awssdk.services.macie2.model.UserIdentityType.AWS_ACCOUNT
  }
  case object AWSService extends zio.aws.macie2.model.UserIdentityType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UserIdentityType =
      software.amazon.awssdk.services.macie2.model.UserIdentityType.AWS_SERVICE
  }
}
