package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.macie.model.primitives.AWSAccountId
import scala.jdk.CollectionConverters._
final case class AssociateMemberAccountRequest(memberAccountId: AWSAccountId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.AssociateMemberAccountRequest = {
    import AssociateMemberAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.AssociateMemberAccountRequest
      .builder()
      .memberAccountId(AWSAccountId.unwrap(memberAccountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.AssociateMemberAccountRequest.ReadOnly =
    zio.aws.macie.model.AssociateMemberAccountRequest.wrap(buildAwsValue())
}
object AssociateMemberAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.AssociateMemberAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.AssociateMemberAccountRequest =
      zio.aws.macie.model.AssociateMemberAccountRequest(memberAccountId)
    def memberAccountId: AWSAccountId
    def getMemberAccountId: ZIO[Any, Nothing, AWSAccountId] =
      ZIO.succeed(memberAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.AssociateMemberAccountRequest
  ) extends zio.aws.macie.model.AssociateMemberAccountRequest.ReadOnly {
    override val memberAccountId: AWSAccountId =
      zio.aws.macie.model.primitives.AWSAccountId(impl.memberAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.AssociateMemberAccountRequest
  ): zio.aws.macie.model.AssociateMemberAccountRequest.ReadOnly = new Wrapper(
    impl
  )
}
