package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateS3ResourcesResponse(
    failedS3Resources: Optional[
      Iterable[zio.aws.macie.model.FailedS3Resource]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.AssociateS3ResourcesResponse = {
    import AssociateS3ResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.AssociateS3ResourcesResponse
      .builder()
      .optionallyWith(
        failedS3Resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedS3Resources)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.AssociateS3ResourcesResponse.ReadOnly =
    zio.aws.macie.model.AssociateS3ResourcesResponse.wrap(buildAwsValue())
}
object AssociateS3ResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.AssociateS3ResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.AssociateS3ResourcesResponse =
      zio.aws.macie.model.AssociateS3ResourcesResponse(
        failedS3Resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedS3Resources
        : Optional[List[zio.aws.macie.model.FailedS3Resource.ReadOnly]]
    def getFailedS3Resources: ZIO[Any, AwsError, List[
      zio.aws.macie.model.FailedS3Resource.ReadOnly
    ]] = AwsError.unwrapOptionField("failedS3Resources", failedS3Resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.AssociateS3ResourcesResponse
  ) extends zio.aws.macie.model.AssociateS3ResourcesResponse.ReadOnly {
    override val failedS3Resources
        : Optional[List[zio.aws.macie.model.FailedS3Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedS3Resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie.model.FailedS3Resource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.AssociateS3ResourcesResponse
  ): zio.aws.macie.model.AssociateS3ResourcesResponse.ReadOnly = new Wrapper(
    impl
  )
}
