package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ClassificationType(
    oneTime: zio.aws.macie.model.S3OneTimeClassificationType,
    continuous: zio.aws.macie.model.S3ContinuousClassificationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.ClassificationType = {
    import ClassificationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.ClassificationType
      .builder()
      .oneTime(oneTime.unwrap)
      .continuous(continuous.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.ClassificationType.ReadOnly =
    zio.aws.macie.model.ClassificationType.wrap(buildAwsValue())
}
object ClassificationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.ClassificationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.ClassificationType =
      zio.aws.macie.model.ClassificationType(oneTime, continuous)
    def oneTime: zio.aws.macie.model.S3OneTimeClassificationType
    def continuous: zio.aws.macie.model.S3ContinuousClassificationType
    def getOneTime
        : ZIO[Any, Nothing, zio.aws.macie.model.S3OneTimeClassificationType] =
      ZIO.succeed(oneTime)
    def getContinuous: ZIO[
      Any,
      Nothing,
      zio.aws.macie.model.S3ContinuousClassificationType
    ] = ZIO.succeed(continuous)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.ClassificationType
  ) extends zio.aws.macie.model.ClassificationType.ReadOnly {
    override val oneTime: zio.aws.macie.model.S3OneTimeClassificationType =
      zio.aws.macie.model.S3OneTimeClassificationType.wrap(impl.oneTime())
    override val continuous
        : zio.aws.macie.model.S3ContinuousClassificationType =
      zio.aws.macie.model.S3ContinuousClassificationType.wrap(impl.continuous())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.ClassificationType
  ): zio.aws.macie.model.ClassificationType.ReadOnly = new Wrapper(impl)
}
