package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClassificationTypeUpdate(
    oneTime: Optional[zio.aws.macie.model.S3OneTimeClassificationType] =
      Optional.Absent,
    continuous: Optional[zio.aws.macie.model.S3ContinuousClassificationType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.ClassificationTypeUpdate = {
    import ClassificationTypeUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.ClassificationTypeUpdate
      .builder()
      .optionallyWith(oneTime.map(value => value.unwrap))(_.oneTime)
      .optionallyWith(continuous.map(value => value.unwrap))(_.continuous)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.ClassificationTypeUpdate.ReadOnly =
    zio.aws.macie.model.ClassificationTypeUpdate.wrap(buildAwsValue())
}
object ClassificationTypeUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.ClassificationTypeUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.ClassificationTypeUpdate =
      zio.aws.macie.model.ClassificationTypeUpdate(
        oneTime.map(value => value),
        continuous.map(value => value)
      )
    def oneTime: Optional[zio.aws.macie.model.S3OneTimeClassificationType]
    def continuous: Optional[zio.aws.macie.model.S3ContinuousClassificationType]
    def getOneTime
        : ZIO[Any, AwsError, zio.aws.macie.model.S3OneTimeClassificationType] =
      AwsError.unwrapOptionField("oneTime", oneTime)
    def getContinuous: ZIO[
      Any,
      AwsError,
      zio.aws.macie.model.S3ContinuousClassificationType
    ] = AwsError.unwrapOptionField("continuous", continuous)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.ClassificationTypeUpdate
  ) extends zio.aws.macie.model.ClassificationTypeUpdate.ReadOnly {
    override val oneTime
        : Optional[zio.aws.macie.model.S3OneTimeClassificationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oneTime())
        .map(value =>
          zio.aws.macie.model.S3OneTimeClassificationType.wrap(value)
        )
    override val continuous
        : Optional[zio.aws.macie.model.S3ContinuousClassificationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.continuous())
        .map(value =>
          zio.aws.macie.model.S3ContinuousClassificationType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.ClassificationTypeUpdate
  ): zio.aws.macie.model.ClassificationTypeUpdate.ReadOnly = new Wrapper(impl)
}
