package zio.aws.macie.model
import zio.aws.macie.model.primitives.{MaxResults, NextToken, AWSAccountId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListS3ResourcesRequest(
    memberAccountId: Optional[AWSAccountId] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest = {
    import ListS3ResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest
      .builder()
      .optionallyWith(
        memberAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.memberAccountId)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.ListS3ResourcesRequest.ReadOnly =
    zio.aws.macie.model.ListS3ResourcesRequest.wrap(buildAwsValue())
}
object ListS3ResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.ListS3ResourcesRequest =
      zio.aws.macie.model.ListS3ResourcesRequest(
        memberAccountId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def memberAccountId: Optional[AWSAccountId]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getMemberAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("memberAccountId", memberAccountId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest
  ) extends zio.aws.macie.model.ListS3ResourcesRequest.ReadOnly {
    override val memberAccountId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.memberAccountId())
      .map(value => zio.aws.macie.model.primitives.AWSAccountId(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.macie.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.macie.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest
  ): zio.aws.macie.model.ListS3ResourcesRequest.ReadOnly = new Wrapper(impl)
}
