package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.macie.model.primitives.AWSAccountId
import scala.jdk.CollectionConverters.*
final case class MemberAccount(
    accountId: Optional[AWSAccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.MemberAccount = {
    import MemberAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.MemberAccount
      .builder()
      .optionallyWith(
        accountId.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.MemberAccount.ReadOnly =
    zio.aws.macie.model.MemberAccount.wrap(buildAwsValue())
}
object MemberAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.MemberAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.MemberAccount =
      zio.aws.macie.model.MemberAccount(accountId.map(value => value))
    def accountId: Optional[AWSAccountId]
    def getAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.MemberAccount
  ) extends zio.aws.macie.model.MemberAccount.ReadOnly {
    override val accountId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.macie.model.primitives.AWSAccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.MemberAccount
  ): zio.aws.macie.model.MemberAccount.ReadOnly = new Wrapper(impl)
}
