package zio.aws.macie.model
import scala.jdk.CollectionConverters.*
sealed trait S3ContinuousClassificationType {
  def unwrap: software.amazon.awssdk.services.macie.model.S3ContinuousClassificationType
}
object S3ContinuousClassificationType {
  def wrap(
      value: software.amazon.awssdk.services.macie.model.S3ContinuousClassificationType
  ): zio.aws.macie.model.S3ContinuousClassificationType = value match {
    case software.amazon.awssdk.services.macie.model.S3ContinuousClassificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie.model.S3ContinuousClassificationType.FULL =>
      val r = FULL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie.model.S3ContinuousClassificationType {
    override def unwrap
        : software.amazon.awssdk.services.macie.model.S3ContinuousClassificationType =
      software.amazon.awssdk.services.macie.model.S3ContinuousClassificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL extends zio.aws.macie.model.S3ContinuousClassificationType {
    override def unwrap
        : software.amazon.awssdk.services.macie.model.S3ContinuousClassificationType =
      software.amazon.awssdk.services.macie.model.S3ContinuousClassificationType.FULL
  }
}
