package zio.aws.macie.model
import scala.jdk.CollectionConverters.*
sealed trait S3OneTimeClassificationType {
  def unwrap
      : software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType
}
object S3OneTimeClassificationType {
  def wrap(
      value: software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType
  ): zio.aws.macie.model.S3OneTimeClassificationType = value match {
    case software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType.FULL =>
      val r = FULL
      r
    case software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie.model.S3OneTimeClassificationType {
    override def unwrap
        : software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType =
      software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL extends zio.aws.macie.model.S3OneTimeClassificationType {
    override def unwrap
        : software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType =
      software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType.FULL
  }
  case object NONE extends zio.aws.macie.model.S3OneTimeClassificationType {
    override def unwrap
        : software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType =
      software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType.NONE
  }
}
