package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.macie.model.primitives.{Prefix, BucketName}
import scala.jdk.CollectionConverters.*
final case class S3Resource(
    bucketName: BucketName,
    prefix: Optional[Prefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.S3Resource = {
    import S3Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.S3Resource
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.S3Resource.ReadOnly =
    zio.aws.macie.model.S3Resource.wrap(buildAwsValue())
}
object S3Resource {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie.model.S3Resource] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.S3Resource =
      zio.aws.macie.model.S3Resource(bucketName, prefix.map(value => value))
    def bucketName: BucketName
    def prefix: Optional[Prefix]
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.S3Resource
  ) extends zio.aws.macie.model.S3Resource.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.macie.model.primitives.BucketName(impl.bucketName())
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.macie.model.primitives.Prefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.S3Resource
  ): zio.aws.macie.model.S3Resource.ReadOnly = new Wrapper(impl)
}
