package zio.aws.medialive
import zio.aws.medialive.model.DescribeInputDeviceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.medialive.model.{
  ListMultiplexProgramsRequest,
  DescribeOfferingRequest,
  TransferInputDeviceRequest,
  PurchaseOfferingRequest,
  DescribeInputDeviceRequest,
  CreateMultiplexProgramRequest,
  StartChannelRequest,
  AcceptInputDeviceTransferRequest,
  CreatePartnerInputRequest,
  DeleteTagsRequest,
  ListOfferingsRequest,
  DeleteChannelRequest,
  UpdateMultiplexRequest,
  DeleteScheduleRequest,
  ListReservationsRequest,
  BatchStartRequest,
  RejectInputDeviceTransferRequest,
  CreateInputRequest,
  CreateChannelRequest,
  StopMultiplexRequest,
  DescribeReservationRequest,
  UpdateInputRequest,
  CreateTagsRequest,
  UpdateMultiplexProgramRequest,
  BatchDeleteRequest,
  ListTagsForResourceRequest,
  DescribeMultiplexRequest,
  ListInputSecurityGroupsRequest,
  DescribeInputRequest,
  DeleteMultiplexRequest,
  ListInputsRequest,
  ListMultiplexesRequest,
  UpdateInputSecurityGroupRequest,
  ClaimDeviceRequest,
  DescribeInputDeviceThumbnailRequest,
  DeleteInputRequest,
  UpdateChannelClassRequest,
  UpdateChannelRequest,
  DeleteMultiplexProgramRequest,
  DeleteInputSecurityGroupRequest,
  BatchStopRequest,
  ListInputDevicesRequest,
  CreateMultiplexRequest,
  DeleteReservationRequest,
  ListChannelsRequest,
  ListInputDeviceTransfersRequest,
  CreateInputSecurityGroupRequest,
  DescribeInputSecurityGroupRequest,
  BatchUpdateScheduleRequest,
  StartMultiplexRequest,
  StopChannelRequest,
  UpdateInputDeviceRequest,
  UpdateReservationRequest,
  DescribeChannelRequest,
  DescribeScheduleRequest,
  CancelInputDeviceTransferRequest,
  DescribeMultiplexProgramRequest
}
import software.amazon.awssdk.services.medialive.model.{
  ListInputDeviceTransfersResponse,
  Offering,
  CreateChannelResponse,
  DescribeInputSecurityGroupResponse,
  UpdateChannelResponse,
  BatchDeleteResponse,
  StartMultiplexResponse,
  InputSecurityGroup,
  DeleteReservationResponse,
  UpdateMultiplexResponse,
  ListMultiplexProgramsResponse,
  PurchaseOfferingResponse,
  UpdateInputSecurityGroupResponse,
  ListChannelsResponse,
  DeleteTagsResponse,
  DeleteScheduleResponse,
  DeleteInputResponse,
  MultiplexProgramSummary,
  DescribeChannelResponse,
  InputDeviceSummary,
  StopMultiplexResponse,
  DescribeScheduleResponse,
  CreateInputSecurityGroupResponse,
  MultiplexSummary,
  StopChannelResponse,
  ListMultiplexesResponse,
  Input,
  ListOfferingsResponse,
  ChannelSummary,
  UpdateReservationResponse,
  CancelInputDeviceTransferResponse,
  ListTagsForResourceResponse,
  BatchStopResponse,
  ListInputsResponse,
  Reservation,
  BatchUpdateScheduleResponse,
  ListInputSecurityGroupsResponse,
  RejectInputDeviceTransferResponse,
  ClaimDeviceResponse,
  DescribeInputResponse,
  UpdateChannelClassResponse,
  DeleteMultiplexProgramResponse,
  DescribeReservationResponse,
  DescribeInputDeviceResponse,
  TransferInputDeviceResponse,
  UpdateInputResponse,
  CreateMultiplexResponse,
  StartChannelResponse,
  DescribeMultiplexProgramResponse,
  CreateInputResponse,
  DescribeMultiplexResponse,
  TransferringInputDeviceSummary,
  DeleteInputSecurityGroupResponse,
  DescribeOfferingResponse,
  ListReservationsResponse,
  DeleteMultiplexResponse,
  CreateMultiplexProgramResponse,
  UpdateInputDeviceResponse,
  CreatePartnerInputResponse,
  DeleteChannelResponse,
  AcceptInputDeviceTransferResponse,
  BatchStartResponse,
  DescribeInputDeviceThumbnailResponse,
  ListInputDevicesResponse,
  UpdateMultiplexProgramResponse,
  ScheduleAction,
  CreateTagsResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.medialive.{
  MediaLiveAsyncClientBuilder,
  MediaLiveAsyncClient
}
import scala.jdk.CollectionConverters._
trait MediaLive extends AspectSupport[MediaLive] {
  val api: MediaLiveAsyncClient
  def updateMultiplexProgram(request: UpdateMultiplexProgramRequest): IO[
    AwsError,
    zio.aws.medialive.model.UpdateMultiplexProgramResponse.ReadOnly
  ]
  def deleteReservation(
      request: DeleteReservationRequest
  ): IO[AwsError, zio.aws.medialive.model.DeleteReservationResponse.ReadOnly]
  def listMultiplexes(
      request: ListMultiplexesRequest
  ): ZStream[Any, AwsError, zio.aws.medialive.model.MultiplexSummary.ReadOnly]
  def listMultiplexesPaginated(
      request: ListMultiplexesRequest
  ): IO[AwsError, zio.aws.medialive.model.ListMultiplexesResponse.ReadOnly]
  def createMultiplex(
      request: CreateMultiplexRequest
  ): IO[AwsError, zio.aws.medialive.model.CreateMultiplexResponse.ReadOnly]
  def listChannels(
      request: ListChannelsRequest
  ): ZStream[Any, AwsError, zio.aws.medialive.model.ChannelSummary.ReadOnly]
  def listChannelsPaginated(
      request: ListChannelsRequest
  ): IO[AwsError, zio.aws.medialive.model.ListChannelsResponse.ReadOnly]
  def describeOffering(
      request: DescribeOfferingRequest
  ): IO[AwsError, zio.aws.medialive.model.DescribeOfferingResponse.ReadOnly]
  def deleteMultiplex(
      request: DeleteMultiplexRequest
  ): IO[AwsError, zio.aws.medialive.model.DeleteMultiplexResponse.ReadOnly]
  def updateInputDevice(
      request: UpdateInputDeviceRequest
  ): IO[AwsError, zio.aws.medialive.model.UpdateInputDeviceResponse.ReadOnly]
  def batchStop(
      request: BatchStopRequest
  ): IO[AwsError, zio.aws.medialive.model.BatchStopResponse.ReadOnly]
  def listMultiplexPrograms(request: ListMultiplexProgramsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.medialive.model.MultiplexProgramSummary.ReadOnly
  ]
  def listMultiplexProgramsPaginated(request: ListMultiplexProgramsRequest): IO[
    AwsError,
    zio.aws.medialive.model.ListMultiplexProgramsResponse.ReadOnly
  ]
  def claimDevice(
      request: ClaimDeviceRequest
  ): IO[AwsError, zio.aws.medialive.model.ClaimDeviceResponse.ReadOnly]
  def listInputSecurityGroups(
      request: ListInputSecurityGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.medialive.model.InputSecurityGroup.ReadOnly]
  def listInputSecurityGroupsPaginated(
      request: ListInputSecurityGroupsRequest
  ): IO[
    AwsError,
    zio.aws.medialive.model.ListInputSecurityGroupsResponse.ReadOnly
  ]
  def acceptInputDeviceTransfer(request: AcceptInputDeviceTransferRequest): IO[
    AwsError,
    zio.aws.medialive.model.AcceptInputDeviceTransferResponse.ReadOnly
  ]
  def cancelInputDeviceTransfer(request: CancelInputDeviceTransferRequest): IO[
    AwsError,
    zio.aws.medialive.model.CancelInputDeviceTransferResponse.ReadOnly
  ]
  def stopMultiplex(
      request: StopMultiplexRequest
  ): IO[AwsError, zio.aws.medialive.model.StopMultiplexResponse.ReadOnly]
  def batchStart(
      request: BatchStartRequest
  ): IO[AwsError, zio.aws.medialive.model.BatchStartResponse.ReadOnly]
  def describeInputSecurityGroup(
      request: DescribeInputSecurityGroupRequest
  ): IO[
    AwsError,
    zio.aws.medialive.model.DescribeInputSecurityGroupResponse.ReadOnly
  ]
  def deleteChannel(
      request: DeleteChannelRequest
  ): IO[AwsError, zio.aws.medialive.model.DeleteChannelResponse.ReadOnly]
  def deleteInput(
      request: DeleteInputRequest
  ): IO[AwsError, zio.aws.medialive.model.DeleteInputResponse.ReadOnly]
  def describeMultiplexProgram(request: DescribeMultiplexProgramRequest): IO[
    AwsError,
    zio.aws.medialive.model.DescribeMultiplexProgramResponse.ReadOnly
  ]
  def startMultiplex(
      request: StartMultiplexRequest
  ): IO[AwsError, zio.aws.medialive.model.StartMultiplexResponse.ReadOnly]
  def startChannel(
      request: StartChannelRequest
  ): IO[AwsError, zio.aws.medialive.model.StartChannelResponse.ReadOnly]
  def listInputs(
      request: ListInputsRequest
  ): ZStream[Any, AwsError, zio.aws.medialive.model.Input.ReadOnly]
  def listInputsPaginated(
      request: ListInputsRequest
  ): IO[AwsError, zio.aws.medialive.model.ListInputsResponse.ReadOnly]
  def listReservations(
      request: ListReservationsRequest
  ): ZStream[Any, AwsError, zio.aws.medialive.model.Reservation.ReadOnly]
  def listReservationsPaginated(
      request: ListReservationsRequest
  ): IO[AwsError, zio.aws.medialive.model.ListReservationsResponse.ReadOnly]
  def listInputDevices(
      request: ListInputDevicesRequest
  ): ZStream[Any, AwsError, zio.aws.medialive.model.InputDeviceSummary.ReadOnly]
  def listInputDevicesPaginated(
      request: ListInputDevicesRequest
  ): IO[AwsError, zio.aws.medialive.model.ListInputDevicesResponse.ReadOnly]
  def listInputDeviceTransfers(
      request: ListInputDeviceTransfersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.medialive.model.TransferringInputDeviceSummary.ReadOnly
  ]
  def listInputDeviceTransfersPaginated(
      request: ListInputDeviceTransfersRequest
  ): IO[
    AwsError,
    zio.aws.medialive.model.ListInputDeviceTransfersResponse.ReadOnly
  ]
  def updateInputSecurityGroup(request: UpdateInputSecurityGroupRequest): IO[
    AwsError,
    zio.aws.medialive.model.UpdateInputSecurityGroupResponse.ReadOnly
  ]
  def describeInputDeviceThumbnail(
      request: DescribeInputDeviceThumbnailRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse.ReadOnly,
    Byte
  ]]
  def describeReservation(
      request: DescribeReservationRequest
  ): IO[AwsError, zio.aws.medialive.model.DescribeReservationResponse.ReadOnly]
  def createChannel(
      request: CreateChannelRequest
  ): IO[AwsError, zio.aws.medialive.model.CreateChannelResponse.ReadOnly]
  def describeInputDevice(
      request: DescribeInputDeviceRequest
  ): IO[AwsError, ReadOnly]
  def stopChannel(
      request: StopChannelRequest
  ): IO[AwsError, zio.aws.medialive.model.StopChannelResponse.ReadOnly]
  def createMultiplexProgram(request: CreateMultiplexProgramRequest): IO[
    AwsError,
    zio.aws.medialive.model.CreateMultiplexProgramResponse.ReadOnly
  ]
  def updateInput(
      request: UpdateInputRequest
  ): IO[AwsError, zio.aws.medialive.model.UpdateInputResponse.ReadOnly]
  def listOfferings(
      request: ListOfferingsRequest
  ): ZStream[Any, AwsError, zio.aws.medialive.model.Offering.ReadOnly]
  def listOfferingsPaginated(
      request: ListOfferingsRequest
  ): IO[AwsError, zio.aws.medialive.model.ListOfferingsResponse.ReadOnly]
  def describeSchedule(
      request: DescribeScheduleRequest
  ): ZStream[Any, AwsError, zio.aws.medialive.model.ScheduleAction.ReadOnly]
  def describeSchedulePaginated(
      request: DescribeScheduleRequest
  ): IO[AwsError, zio.aws.medialive.model.DescribeScheduleResponse.ReadOnly]
  def updateChannelClass(
      request: UpdateChannelClassRequest
  ): IO[AwsError, zio.aws.medialive.model.UpdateChannelClassResponse.ReadOnly]
  def deleteInputSecurityGroup(request: DeleteInputSecurityGroupRequest): IO[
    AwsError,
    zio.aws.medialive.model.DeleteInputSecurityGroupResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.medialive.model.ListTagsForResourceResponse.ReadOnly]
  def describeChannel(
      request: DescribeChannelRequest
  ): IO[AwsError, zio.aws.medialive.model.DescribeChannelResponse.ReadOnly]
  def createPartnerInput(
      request: CreatePartnerInputRequest
  ): IO[AwsError, zio.aws.medialive.model.CreatePartnerInputResponse.ReadOnly]
  def purchaseOffering(
      request: PurchaseOfferingRequest
  ): IO[AwsError, zio.aws.medialive.model.PurchaseOfferingResponse.ReadOnly]
  def updateMultiplex(
      request: UpdateMultiplexRequest
  ): IO[AwsError, zio.aws.medialive.model.UpdateMultiplexResponse.ReadOnly]
  def describeMultiplex(
      request: DescribeMultiplexRequest
  ): IO[AwsError, zio.aws.medialive.model.DescribeMultiplexResponse.ReadOnly]
  def updateReservation(
      request: UpdateReservationRequest
  ): IO[AwsError, zio.aws.medialive.model.UpdateReservationResponse.ReadOnly]
  def batchDelete(
      request: BatchDeleteRequest
  ): IO[AwsError, zio.aws.medialive.model.BatchDeleteResponse.ReadOnly]
  def deleteTags(request: DeleteTagsRequest): IO[AwsError, Unit]
  def deleteSchedule(
      request: DeleteScheduleRequest
  ): IO[AwsError, zio.aws.medialive.model.DeleteScheduleResponse.ReadOnly]
  def rejectInputDeviceTransfer(request: RejectInputDeviceTransferRequest): IO[
    AwsError,
    zio.aws.medialive.model.RejectInputDeviceTransferResponse.ReadOnly
  ]
  def batchUpdateSchedule(
      request: BatchUpdateScheduleRequest
  ): IO[AwsError, zio.aws.medialive.model.BatchUpdateScheduleResponse.ReadOnly]
  def transferInputDevice(
      request: TransferInputDeviceRequest
  ): IO[AwsError, zio.aws.medialive.model.TransferInputDeviceResponse.ReadOnly]
  def updateChannel(
      request: UpdateChannelRequest
  ): IO[AwsError, zio.aws.medialive.model.UpdateChannelResponse.ReadOnly]
  def describeInput(
      request: DescribeInputRequest
  ): IO[AwsError, zio.aws.medialive.model.DescribeInputResponse.ReadOnly]
  def createInput(
      request: CreateInputRequest
  ): IO[AwsError, zio.aws.medialive.model.CreateInputResponse.ReadOnly]
  def createInputSecurityGroup(request: CreateInputSecurityGroupRequest): IO[
    AwsError,
    zio.aws.medialive.model.CreateInputSecurityGroupResponse.ReadOnly
  ]
  def createTags(request: CreateTagsRequest): IO[AwsError, Unit]
  def deleteMultiplexProgram(request: DeleteMultiplexProgramRequest): IO[
    AwsError,
    zio.aws.medialive.model.DeleteMultiplexProgramResponse.ReadOnly
  ]
}
object MediaLive {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MediaLive] = customized(
    identity
  )
  def customized(
      customization: MediaLiveAsyncClientBuilder => MediaLiveAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MediaLive] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: MediaLiveAsyncClientBuilder => MediaLiveAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, MediaLive] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = MediaLiveAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MediaLiveAsyncClient, MediaLiveAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[MediaLiveAsyncClient, MediaLiveAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new MediaLiveImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class MediaLiveImpl[R](
      override val api: MediaLiveAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MediaLive
      with AwsServiceBase[R] {
    override val serviceName: String = "MediaLive"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MediaLiveImpl[R1] = new MediaLiveImpl(api, newAspect, r)
    def updateMultiplexProgram(request: UpdateMultiplexProgramRequest): IO[
      AwsError,
      zio.aws.medialive.model.UpdateMultiplexProgramResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest,
      UpdateMultiplexProgramResponse
    ]("updateMultiplexProgram", api.updateMultiplexProgram)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.UpdateMultiplexProgramResponse.wrap)
      .provideEnvironment(r)
    def deleteReservation(request: DeleteReservationRequest): IO[
      AwsError,
      zio.aws.medialive.model.DeleteReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.DeleteReservationRequest,
      DeleteReservationResponse
    ]("deleteReservation", api.deleteReservation)(request.buildAwsValue())
      .map(zio.aws.medialive.model.DeleteReservationResponse.wrap)
      .provideEnvironment(r)
    def listMultiplexes(request: ListMultiplexesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest,
      ListMultiplexesResponse,
      MultiplexSummary
    ](
      "listMultiplexes",
      api.listMultiplexes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.multiplexes().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.medialive.model.MultiplexSummary.wrap(item))
      .provideEnvironment(r)
    def listMultiplexesPaginated(
        request: ListMultiplexesRequest
    ): IO[AwsError, zio.aws.medialive.model.ListMultiplexesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest,
        ListMultiplexesResponse
      ]("listMultiplexes", api.listMultiplexes)(request.buildAwsValue())
        .map(zio.aws.medialive.model.ListMultiplexesResponse.wrap)
        .provideEnvironment(r)
    def createMultiplex(
        request: CreateMultiplexRequest
    ): IO[AwsError, zio.aws.medialive.model.CreateMultiplexResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest,
        CreateMultiplexResponse
      ]("createMultiplex", api.createMultiplex)(request.buildAwsValue())
        .map(zio.aws.medialive.model.CreateMultiplexResponse.wrap)
        .provideEnvironment(r)
    def listChannels(
        request: ListChannelsRequest
    ): ZStream[Any, AwsError, zio.aws.medialive.model.ChannelSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.medialive.model.ListChannelsRequest,
        ListChannelsResponse,
        ChannelSummary
      ](
        "listChannels",
        api.listChannels,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.channels().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.medialive.model.ChannelSummary.wrap(item))
        .provideEnvironment(r)
    def listChannelsPaginated(
        request: ListChannelsRequest
    ): IO[AwsError, zio.aws.medialive.model.ListChannelsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.ListChannelsRequest,
        ListChannelsResponse
      ]("listChannels", api.listChannels)(request.buildAwsValue())
        .map(zio.aws.medialive.model.ListChannelsResponse.wrap)
        .provideEnvironment(r)
    def describeOffering(
        request: DescribeOfferingRequest
    ): IO[AwsError, zio.aws.medialive.model.DescribeOfferingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.DescribeOfferingRequest,
        DescribeOfferingResponse
      ]("describeOffering", api.describeOffering)(request.buildAwsValue())
        .map(zio.aws.medialive.model.DescribeOfferingResponse.wrap)
        .provideEnvironment(r)
    def deleteMultiplex(
        request: DeleteMultiplexRequest
    ): IO[AwsError, zio.aws.medialive.model.DeleteMultiplexResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.DeleteMultiplexRequest,
        DeleteMultiplexResponse
      ]("deleteMultiplex", api.deleteMultiplex)(request.buildAwsValue())
        .map(zio.aws.medialive.model.DeleteMultiplexResponse.wrap)
        .provideEnvironment(r)
    def updateInputDevice(request: UpdateInputDeviceRequest): IO[
      AwsError,
      zio.aws.medialive.model.UpdateInputDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest,
      UpdateInputDeviceResponse
    ]("updateInputDevice", api.updateInputDevice)(request.buildAwsValue())
      .map(zio.aws.medialive.model.UpdateInputDeviceResponse.wrap)
      .provideEnvironment(r)
    def batchStop(
        request: BatchStopRequest
    ): IO[AwsError, zio.aws.medialive.model.BatchStopResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.BatchStopRequest,
        BatchStopResponse
      ]("batchStop", api.batchStop)(request.buildAwsValue())
        .map(zio.aws.medialive.model.BatchStopResponse.wrap)
        .provideEnvironment(r)
    def listMultiplexPrograms(request: ListMultiplexProgramsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexProgramSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest,
      ListMultiplexProgramsResponse,
      MultiplexProgramSummary
    ](
      "listMultiplexPrograms",
      api.listMultiplexPrograms,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.multiplexPrograms().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.medialive.model.MultiplexProgramSummary.wrap(item))
      .provideEnvironment(r)
    def listMultiplexProgramsPaginated(
        request: ListMultiplexProgramsRequest
    ): IO[
      AwsError,
      zio.aws.medialive.model.ListMultiplexProgramsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest,
      ListMultiplexProgramsResponse
    ]("listMultiplexPrograms", api.listMultiplexPrograms)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.ListMultiplexProgramsResponse.wrap)
      .provideEnvironment(r)
    def claimDevice(
        request: ClaimDeviceRequest
    ): IO[AwsError, zio.aws.medialive.model.ClaimDeviceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.ClaimDeviceRequest,
        ClaimDeviceResponse
      ]("claimDevice", api.claimDevice)(request.buildAwsValue())
        .map(zio.aws.medialive.model.ClaimDeviceResponse.wrap)
        .provideEnvironment(r)
    def listInputSecurityGroups(
        request: ListInputSecurityGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.medialive.model.InputSecurityGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest,
      ListInputSecurityGroupsResponse,
      InputSecurityGroup
    ](
      "listInputSecurityGroups",
      api.listInputSecurityGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.inputSecurityGroups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.medialive.model.InputSecurityGroup.wrap(item))
      .provideEnvironment(r)
    def listInputSecurityGroupsPaginated(
        request: ListInputSecurityGroupsRequest
    ): IO[
      AwsError,
      zio.aws.medialive.model.ListInputSecurityGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest,
      ListInputSecurityGroupsResponse
    ]("listInputSecurityGroups", api.listInputSecurityGroups)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.ListInputSecurityGroupsResponse.wrap)
      .provideEnvironment(r)
    def acceptInputDeviceTransfer(
        request: AcceptInputDeviceTransferRequest
    ): IO[
      AwsError,
      zio.aws.medialive.model.AcceptInputDeviceTransferResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferRequest,
      AcceptInputDeviceTransferResponse
    ]("acceptInputDeviceTransfer", api.acceptInputDeviceTransfer)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.AcceptInputDeviceTransferResponse.wrap)
      .provideEnvironment(r)
    def cancelInputDeviceTransfer(
        request: CancelInputDeviceTransferRequest
    ): IO[
      AwsError,
      zio.aws.medialive.model.CancelInputDeviceTransferResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferRequest,
      CancelInputDeviceTransferResponse
    ]("cancelInputDeviceTransfer", api.cancelInputDeviceTransfer)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.CancelInputDeviceTransferResponse.wrap)
      .provideEnvironment(r)
    def stopMultiplex(
        request: StopMultiplexRequest
    ): IO[AwsError, zio.aws.medialive.model.StopMultiplexResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.StopMultiplexRequest,
        StopMultiplexResponse
      ]("stopMultiplex", api.stopMultiplex)(request.buildAwsValue())
        .map(zio.aws.medialive.model.StopMultiplexResponse.wrap)
        .provideEnvironment(r)
    def batchStart(
        request: BatchStartRequest
    ): IO[AwsError, zio.aws.medialive.model.BatchStartResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.BatchStartRequest,
        BatchStartResponse
      ]("batchStart", api.batchStart)(request.buildAwsValue())
        .map(zio.aws.medialive.model.BatchStartResponse.wrap)
        .provideEnvironment(r)
    def describeInputSecurityGroup(
        request: DescribeInputSecurityGroupRequest
    ): IO[
      AwsError,
      zio.aws.medialive.model.DescribeInputSecurityGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest,
      DescribeInputSecurityGroupResponse
    ]("describeInputSecurityGroup", api.describeInputSecurityGroup)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.DescribeInputSecurityGroupResponse.wrap)
      .provideEnvironment(r)
    def deleteChannel(
        request: DeleteChannelRequest
    ): IO[AwsError, zio.aws.medialive.model.DeleteChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.DeleteChannelRequest,
        DeleteChannelResponse
      ]("deleteChannel", api.deleteChannel)(request.buildAwsValue())
        .map(zio.aws.medialive.model.DeleteChannelResponse.wrap)
        .provideEnvironment(r)
    def deleteInput(
        request: DeleteInputRequest
    ): IO[AwsError, zio.aws.medialive.model.DeleteInputResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.DeleteInputRequest,
        DeleteInputResponse
      ]("deleteInput", api.deleteInput)(request.buildAwsValue())
        .map(zio.aws.medialive.model.DeleteInputResponse.wrap)
        .provideEnvironment(r)
    def describeMultiplexProgram(request: DescribeMultiplexProgramRequest): IO[
      AwsError,
      zio.aws.medialive.model.DescribeMultiplexProgramResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramRequest,
      DescribeMultiplexProgramResponse
    ]("describeMultiplexProgram", api.describeMultiplexProgram)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.DescribeMultiplexProgramResponse.wrap)
      .provideEnvironment(r)
    def startMultiplex(
        request: StartMultiplexRequest
    ): IO[AwsError, zio.aws.medialive.model.StartMultiplexResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.StartMultiplexRequest,
        StartMultiplexResponse
      ]("startMultiplex", api.startMultiplex)(request.buildAwsValue())
        .map(zio.aws.medialive.model.StartMultiplexResponse.wrap)
        .provideEnvironment(r)
    def startChannel(
        request: StartChannelRequest
    ): IO[AwsError, zio.aws.medialive.model.StartChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.StartChannelRequest,
        StartChannelResponse
      ]("startChannel", api.startChannel)(request.buildAwsValue())
        .map(zio.aws.medialive.model.StartChannelResponse.wrap)
        .provideEnvironment(r)
    def listInputs(
        request: ListInputsRequest
    ): ZStream[Any, AwsError, zio.aws.medialive.model.Input.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.medialive.model.ListInputsRequest,
        ListInputsResponse,
        Input
      ](
        "listInputs",
        api.listInputs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.inputs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.medialive.model.Input.wrap(item))
        .provideEnvironment(r)
    def listInputsPaginated(
        request: ListInputsRequest
    ): IO[AwsError, zio.aws.medialive.model.ListInputsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.ListInputsRequest,
        ListInputsResponse
      ]("listInputs", api.listInputs)(request.buildAwsValue())
        .map(zio.aws.medialive.model.ListInputsResponse.wrap)
        .provideEnvironment(r)
    def listReservations(
        request: ListReservationsRequest
    ): ZStream[Any, AwsError, zio.aws.medialive.model.Reservation.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.medialive.model.ListReservationsRequest,
        ListReservationsResponse,
        Reservation
      ](
        "listReservations",
        api.listReservations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.reservations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.medialive.model.Reservation.wrap(item))
        .provideEnvironment(r)
    def listReservationsPaginated(
        request: ListReservationsRequest
    ): IO[AwsError, zio.aws.medialive.model.ListReservationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.ListReservationsRequest,
        ListReservationsResponse
      ]("listReservations", api.listReservations)(request.buildAwsValue())
        .map(zio.aws.medialive.model.ListReservationsResponse.wrap)
        .provideEnvironment(r)
    def listInputDevices(request: ListInputDevicesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.medialive.model.InputDeviceSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest,
      ListInputDevicesResponse,
      InputDeviceSummary
    ](
      "listInputDevices",
      api.listInputDevices,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.inputDevices().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.medialive.model.InputDeviceSummary.wrap(item))
      .provideEnvironment(r)
    def listInputDevicesPaginated(
        request: ListInputDevicesRequest
    ): IO[AwsError, zio.aws.medialive.model.ListInputDevicesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest,
        ListInputDevicesResponse
      ]("listInputDevices", api.listInputDevices)(request.buildAwsValue())
        .map(zio.aws.medialive.model.ListInputDevicesResponse.wrap)
        .provideEnvironment(r)
    def listInputDeviceTransfers(
        request: ListInputDeviceTransfersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.medialive.model.TransferringInputDeviceSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest,
      ListInputDeviceTransfersResponse,
      TransferringInputDeviceSummary
    ](
      "listInputDeviceTransfers",
      api.listInputDeviceTransfers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.inputDeviceTransfers().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.medialive.model.TransferringInputDeviceSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listInputDeviceTransfersPaginated(
        request: ListInputDeviceTransfersRequest
    ): IO[
      AwsError,
      zio.aws.medialive.model.ListInputDeviceTransfersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest,
      ListInputDeviceTransfersResponse
    ]("listInputDeviceTransfers", api.listInputDeviceTransfers)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.ListInputDeviceTransfersResponse.wrap)
      .provideEnvironment(r)
    def updateInputSecurityGroup(request: UpdateInputSecurityGroupRequest): IO[
      AwsError,
      zio.aws.medialive.model.UpdateInputSecurityGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest,
      UpdateInputSecurityGroupResponse
    ]("updateInputSecurityGroup", api.updateInputSecurityGroup)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.UpdateInputSecurityGroupResponse.wrap)
      .provideEnvironment(r)
    def describeInputDeviceThumbnail(
        request: DescribeInputDeviceThumbnailRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest,
      DescribeInputDeviceThumbnailResponse
    ](
      "describeInputDeviceThumbnail",
      api.describeInputDeviceThumbnail[Task[
        StreamingOutputResult[R, DescribeInputDeviceThumbnailResponse, Byte]
      ]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(
          zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse.wrap
        ).provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeReservation(request: DescribeReservationRequest): IO[
      AwsError,
      zio.aws.medialive.model.DescribeReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.DescribeReservationRequest,
      DescribeReservationResponse
    ]("describeReservation", api.describeReservation)(request.buildAwsValue())
      .map(zio.aws.medialive.model.DescribeReservationResponse.wrap)
      .provideEnvironment(r)
    def createChannel(
        request: CreateChannelRequest
    ): IO[AwsError, zio.aws.medialive.model.CreateChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.CreateChannelRequest,
        CreateChannelResponse
      ]("createChannel", api.createChannel)(request.buildAwsValue())
        .map(zio.aws.medialive.model.CreateChannelResponse.wrap)
        .provideEnvironment(r)
    def describeInputDevice(
        request: DescribeInputDeviceRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.DescribeInputDeviceRequest,
      DescribeInputDeviceResponse
    ]("describeInputDevice", api.describeInputDevice)(request.buildAwsValue())
      .map(zio.aws.medialive.model.DescribeInputDeviceResponse.wrap)
      .provideEnvironment(r)
    def stopChannel(
        request: StopChannelRequest
    ): IO[AwsError, zio.aws.medialive.model.StopChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.StopChannelRequest,
        StopChannelResponse
      ]("stopChannel", api.stopChannel)(request.buildAwsValue())
        .map(zio.aws.medialive.model.StopChannelResponse.wrap)
        .provideEnvironment(r)
    def createMultiplexProgram(request: CreateMultiplexProgramRequest): IO[
      AwsError,
      zio.aws.medialive.model.CreateMultiplexProgramResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest,
      CreateMultiplexProgramResponse
    ]("createMultiplexProgram", api.createMultiplexProgram)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.CreateMultiplexProgramResponse.wrap)
      .provideEnvironment(r)
    def updateInput(
        request: UpdateInputRequest
    ): IO[AwsError, zio.aws.medialive.model.UpdateInputResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.UpdateInputRequest,
        UpdateInputResponse
      ]("updateInput", api.updateInput)(request.buildAwsValue())
        .map(zio.aws.medialive.model.UpdateInputResponse.wrap)
        .provideEnvironment(r)
    def listOfferings(
        request: ListOfferingsRequest
    ): ZStream[Any, AwsError, zio.aws.medialive.model.Offering.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.medialive.model.ListOfferingsRequest,
        ListOfferingsResponse,
        Offering
      ](
        "listOfferings",
        api.listOfferings,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.offerings().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.medialive.model.Offering.wrap(item))
        .provideEnvironment(r)
    def listOfferingsPaginated(
        request: ListOfferingsRequest
    ): IO[AwsError, zio.aws.medialive.model.ListOfferingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.ListOfferingsRequest,
        ListOfferingsResponse
      ]("listOfferings", api.listOfferings)(request.buildAwsValue())
        .map(zio.aws.medialive.model.ListOfferingsResponse.wrap)
        .provideEnvironment(r)
    def describeSchedule(
        request: DescribeScheduleRequest
    ): ZStream[Any, AwsError, zio.aws.medialive.model.ScheduleAction.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest,
        DescribeScheduleResponse,
        ScheduleAction
      ](
        "describeSchedule",
        api.describeSchedule,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.scheduleActions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.medialive.model.ScheduleAction.wrap(item))
        .provideEnvironment(r)
    def describeSchedulePaginated(
        request: DescribeScheduleRequest
    ): IO[AwsError, zio.aws.medialive.model.DescribeScheduleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest,
        DescribeScheduleResponse
      ]("describeSchedule", api.describeSchedule)(request.buildAwsValue())
        .map(zio.aws.medialive.model.DescribeScheduleResponse.wrap)
        .provideEnvironment(r)
    def updateChannelClass(request: UpdateChannelClassRequest): IO[
      AwsError,
      zio.aws.medialive.model.UpdateChannelClassResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest,
      UpdateChannelClassResponse
    ]("updateChannelClass", api.updateChannelClass)(request.buildAwsValue())
      .map(zio.aws.medialive.model.UpdateChannelClassResponse.wrap)
      .provideEnvironment(r)
    def deleteInputSecurityGroup(request: DeleteInputSecurityGroupRequest): IO[
      AwsError,
      zio.aws.medialive.model.DeleteInputSecurityGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest,
      DeleteInputSecurityGroupResponse
    ]("deleteInputSecurityGroup", api.deleteInputSecurityGroup)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.DeleteInputSecurityGroupResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.medialive.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.medialive.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def describeChannel(
        request: DescribeChannelRequest
    ): IO[AwsError, zio.aws.medialive.model.DescribeChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.DescribeChannelRequest,
        DescribeChannelResponse
      ]("describeChannel", api.describeChannel)(request.buildAwsValue())
        .map(zio.aws.medialive.model.DescribeChannelResponse.wrap)
        .provideEnvironment(r)
    def createPartnerInput(request: CreatePartnerInputRequest): IO[
      AwsError,
      zio.aws.medialive.model.CreatePartnerInputResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest,
      CreatePartnerInputResponse
    ]("createPartnerInput", api.createPartnerInput)(request.buildAwsValue())
      .map(zio.aws.medialive.model.CreatePartnerInputResponse.wrap)
      .provideEnvironment(r)
    def purchaseOffering(
        request: PurchaseOfferingRequest
    ): IO[AwsError, zio.aws.medialive.model.PurchaseOfferingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest,
        PurchaseOfferingResponse
      ]("purchaseOffering", api.purchaseOffering)(request.buildAwsValue())
        .map(zio.aws.medialive.model.PurchaseOfferingResponse.wrap)
        .provideEnvironment(r)
    def updateMultiplex(
        request: UpdateMultiplexRequest
    ): IO[AwsError, zio.aws.medialive.model.UpdateMultiplexResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest,
        UpdateMultiplexResponse
      ]("updateMultiplex", api.updateMultiplex)(request.buildAwsValue())
        .map(zio.aws.medialive.model.UpdateMultiplexResponse.wrap)
        .provideEnvironment(r)
    def describeMultiplex(request: DescribeMultiplexRequest): IO[
      AwsError,
      zio.aws.medialive.model.DescribeMultiplexResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest,
      DescribeMultiplexResponse
    ]("describeMultiplex", api.describeMultiplex)(request.buildAwsValue())
      .map(zio.aws.medialive.model.DescribeMultiplexResponse.wrap)
      .provideEnvironment(r)
    def updateReservation(request: UpdateReservationRequest): IO[
      AwsError,
      zio.aws.medialive.model.UpdateReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.UpdateReservationRequest,
      UpdateReservationResponse
    ]("updateReservation", api.updateReservation)(request.buildAwsValue())
      .map(zio.aws.medialive.model.UpdateReservationResponse.wrap)
      .provideEnvironment(r)
    def batchDelete(
        request: BatchDeleteRequest
    ): IO[AwsError, zio.aws.medialive.model.BatchDeleteResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.BatchDeleteRequest,
        BatchDeleteResponse
      ]("batchDelete", api.batchDelete)(request.buildAwsValue())
        .map(zio.aws.medialive.model.BatchDeleteResponse.wrap)
        .provideEnvironment(r)
    def deleteTags(request: DeleteTagsRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.DeleteTagsRequest,
        DeleteTagsResponse
      ]("deleteTags", api.deleteTags)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteSchedule(
        request: DeleteScheduleRequest
    ): IO[AwsError, zio.aws.medialive.model.DeleteScheduleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.DeleteScheduleRequest,
        DeleteScheduleResponse
      ]("deleteSchedule", api.deleteSchedule)(request.buildAwsValue())
        .map(zio.aws.medialive.model.DeleteScheduleResponse.wrap)
        .provideEnvironment(r)
    def rejectInputDeviceTransfer(
        request: RejectInputDeviceTransferRequest
    ): IO[
      AwsError,
      zio.aws.medialive.model.RejectInputDeviceTransferResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferRequest,
      RejectInputDeviceTransferResponse
    ]("rejectInputDeviceTransfer", api.rejectInputDeviceTransfer)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.RejectInputDeviceTransferResponse.wrap)
      .provideEnvironment(r)
    def batchUpdateSchedule(request: BatchUpdateScheduleRequest): IO[
      AwsError,
      zio.aws.medialive.model.BatchUpdateScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest,
      BatchUpdateScheduleResponse
    ]("batchUpdateSchedule", api.batchUpdateSchedule)(request.buildAwsValue())
      .map(zio.aws.medialive.model.BatchUpdateScheduleResponse.wrap)
      .provideEnvironment(r)
    def transferInputDevice(request: TransferInputDeviceRequest): IO[
      AwsError,
      zio.aws.medialive.model.TransferInputDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest,
      TransferInputDeviceResponse
    ]("transferInputDevice", api.transferInputDevice)(request.buildAwsValue())
      .map(zio.aws.medialive.model.TransferInputDeviceResponse.wrap)
      .provideEnvironment(r)
    def updateChannel(
        request: UpdateChannelRequest
    ): IO[AwsError, zio.aws.medialive.model.UpdateChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.UpdateChannelRequest,
        UpdateChannelResponse
      ]("updateChannel", api.updateChannel)(request.buildAwsValue())
        .map(zio.aws.medialive.model.UpdateChannelResponse.wrap)
        .provideEnvironment(r)
    def describeInput(
        request: DescribeInputRequest
    ): IO[AwsError, zio.aws.medialive.model.DescribeInputResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.DescribeInputRequest,
        DescribeInputResponse
      ]("describeInput", api.describeInput)(request.buildAwsValue())
        .map(zio.aws.medialive.model.DescribeInputResponse.wrap)
        .provideEnvironment(r)
    def createInput(
        request: CreateInputRequest
    ): IO[AwsError, zio.aws.medialive.model.CreateInputResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.CreateInputRequest,
        CreateInputResponse
      ]("createInput", api.createInput)(request.buildAwsValue())
        .map(zio.aws.medialive.model.CreateInputResponse.wrap)
        .provideEnvironment(r)
    def createInputSecurityGroup(request: CreateInputSecurityGroupRequest): IO[
      AwsError,
      zio.aws.medialive.model.CreateInputSecurityGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest,
      CreateInputSecurityGroupResponse
    ]("createInputSecurityGroup", api.createInputSecurityGroup)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.CreateInputSecurityGroupResponse.wrap)
      .provideEnvironment(r)
    def createTags(request: CreateTagsRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.medialive.model.CreateTagsRequest,
        CreateTagsResponse
      ]("createTags", api.createTags)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteMultiplexProgram(request: DeleteMultiplexProgramRequest): IO[
      AwsError,
      zio.aws.medialive.model.DeleteMultiplexProgramResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramRequest,
      DeleteMultiplexProgramResponse
    ]("deleteMultiplexProgram", api.deleteMultiplexProgram)(
      request.buildAwsValue()
    ).map(zio.aws.medialive.model.DeleteMultiplexProgramResponse.wrap)
      .provideEnvironment(r)
  }
  def updateMultiplexProgram(request: UpdateMultiplexProgramRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.UpdateMultiplexProgramResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMultiplexProgram(request))
  def deleteReservation(request: DeleteReservationRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DeleteReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReservation(request))
  def listMultiplexes(request: ListMultiplexesRequest): ZStream[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.MultiplexSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMultiplexes(request))
  def listMultiplexesPaginated(request: ListMultiplexesRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ListMultiplexesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMultiplexesPaginated(request))
  def createMultiplex(request: CreateMultiplexRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.CreateMultiplexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMultiplex(request))
  def listChannels(request: ListChannelsRequest): ZStream[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ChannelSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listChannels(request))
  def listChannelsPaginated(request: ListChannelsRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ListChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelsPaginated(request))
  def describeOffering(request: DescribeOfferingRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DescribeOfferingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOffering(request))
  def deleteMultiplex(request: DeleteMultiplexRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DeleteMultiplexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMultiplex(request))
  def updateInputDevice(request: UpdateInputDeviceRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.UpdateInputDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateInputDevice(request))
  def batchStop(request: BatchStopRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.BatchStopResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchStop(request))
  def listMultiplexPrograms(request: ListMultiplexProgramsRequest): ZStream[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.MultiplexProgramSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMultiplexPrograms(request))
  def listMultiplexProgramsPaginated(
      request: ListMultiplexProgramsRequest
  ): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ListMultiplexProgramsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMultiplexProgramsPaginated(request))
  def claimDevice(request: ClaimDeviceRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ClaimDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.claimDevice(request))
  def listInputSecurityGroups(request: ListInputSecurityGroupsRequest): ZStream[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.InputSecurityGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listInputSecurityGroups(request))
  def listInputSecurityGroupsPaginated(
      request: ListInputSecurityGroupsRequest
  ): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ListInputSecurityGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInputSecurityGroupsPaginated(request))
  def acceptInputDeviceTransfer(request: AcceptInputDeviceTransferRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.AcceptInputDeviceTransferResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptInputDeviceTransfer(request))
  def cancelInputDeviceTransfer(request: CancelInputDeviceTransferRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.CancelInputDeviceTransferResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelInputDeviceTransfer(request))
  def stopMultiplex(request: StopMultiplexRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.StopMultiplexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopMultiplex(request))
  def batchStart(request: BatchStartRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.BatchStartResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchStart(request))
  def describeInputSecurityGroup(
      request: DescribeInputSecurityGroupRequest
  ): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DescribeInputSecurityGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInputSecurityGroup(request))
  def deleteChannel(request: DeleteChannelRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DeleteChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteChannel(request))
  def deleteInput(request: DeleteInputRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DeleteInputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInput(request))
  def describeMultiplexProgram(request: DescribeMultiplexProgramRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DescribeMultiplexProgramResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMultiplexProgram(request))
  def startMultiplex(request: StartMultiplexRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.StartMultiplexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMultiplex(request))
  def startChannel(request: StartChannelRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.StartChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startChannel(request))
  def listInputs(request: ListInputsRequest): ZStream[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.Input.ReadOnly
  ] = ZStream.serviceWithStream(_.listInputs(request))
  def listInputsPaginated(request: ListInputsRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ListInputsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInputsPaginated(request))
  def listReservations(request: ListReservationsRequest): ZStream[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.Reservation.ReadOnly
  ] = ZStream.serviceWithStream(_.listReservations(request))
  def listReservationsPaginated(request: ListReservationsRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ListReservationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReservationsPaginated(request))
  def listInputDevices(request: ListInputDevicesRequest): ZStream[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.InputDeviceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInputDevices(request))
  def listInputDevicesPaginated(request: ListInputDevicesRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ListInputDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInputDevicesPaginated(request))
  def listInputDeviceTransfers(
      request: ListInputDeviceTransfersRequest
  ): ZStream[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.TransferringInputDeviceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInputDeviceTransfers(request))
  def listInputDeviceTransfersPaginated(
      request: ListInputDeviceTransfersRequest
  ): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ListInputDeviceTransfersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInputDeviceTransfersPaginated(request))
  def updateInputSecurityGroup(request: UpdateInputSecurityGroupRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.UpdateInputSecurityGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateInputSecurityGroup(request))
  def describeInputDeviceThumbnail(
      request: DescribeInputDeviceThumbnailRequest
  ): ZIO[zio.aws.medialive.MediaLive, AwsError, StreamingOutputResult[
    Any,
    zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.describeInputDeviceThumbnail(request))
  def describeReservation(request: DescribeReservationRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DescribeReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReservation(request))
  def createChannel(request: CreateChannelRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.CreateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannel(request))
  def describeInputDevice(
      request: DescribeInputDeviceRequest
  ): ZIO[zio.aws.medialive.MediaLive, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeInputDevice(request))
  def stopChannel(request: StopChannelRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.StopChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopChannel(request))
  def createMultiplexProgram(request: CreateMultiplexProgramRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.CreateMultiplexProgramResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMultiplexProgram(request))
  def updateInput(request: UpdateInputRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.UpdateInputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateInput(request))
  def listOfferings(request: ListOfferingsRequest): ZStream[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.Offering.ReadOnly
  ] = ZStream.serviceWithStream(_.listOfferings(request))
  def listOfferingsPaginated(request: ListOfferingsRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ListOfferingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOfferingsPaginated(request))
  def describeSchedule(request: DescribeScheduleRequest): ZStream[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ScheduleAction.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSchedule(request))
  def describeSchedulePaginated(request: DescribeScheduleRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DescribeScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSchedulePaginated(request))
  def updateChannelClass(request: UpdateChannelClassRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.UpdateChannelClassResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannelClass(request))
  def deleteInputSecurityGroup(request: DeleteInputSecurityGroupRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DeleteInputSecurityGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInputSecurityGroup(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def describeChannel(request: DescribeChannelRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DescribeChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeChannel(request))
  def createPartnerInput(request: CreatePartnerInputRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.CreatePartnerInputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPartnerInput(request))
  def purchaseOffering(request: PurchaseOfferingRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.PurchaseOfferingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.purchaseOffering(request))
  def updateMultiplex(request: UpdateMultiplexRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.UpdateMultiplexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMultiplex(request))
  def describeMultiplex(request: DescribeMultiplexRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DescribeMultiplexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMultiplex(request))
  def updateReservation(request: UpdateReservationRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.UpdateReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateReservation(request))
  def batchDelete(request: BatchDeleteRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.BatchDeleteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDelete(request))
  def deleteTags(
      request: DeleteTagsRequest
  ): ZIO[zio.aws.medialive.MediaLive, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteTags(request))
  def deleteSchedule(request: DeleteScheduleRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DeleteScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSchedule(request))
  def rejectInputDeviceTransfer(request: RejectInputDeviceTransferRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.RejectInputDeviceTransferResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectInputDeviceTransfer(request))
  def batchUpdateSchedule(request: BatchUpdateScheduleRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.BatchUpdateScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdateSchedule(request))
  def transferInputDevice(request: TransferInputDeviceRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.TransferInputDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.transferInputDevice(request))
  def updateChannel(request: UpdateChannelRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.UpdateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannel(request))
  def describeInput(request: DescribeInputRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DescribeInputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInput(request))
  def createInput(request: CreateInputRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.CreateInputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInput(request))
  def createInputSecurityGroup(request: CreateInputSecurityGroupRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.CreateInputSecurityGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInputSecurityGroup(request))
  def createTags(
      request: CreateTagsRequest
  ): ZIO[zio.aws.medialive.MediaLive, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createTags(request))
  def deleteMultiplexProgram(request: DeleteMultiplexProgramRequest): ZIO[
    zio.aws.medialive.MediaLive,
    AwsError,
    zio.aws.medialive.model.DeleteMultiplexProgramResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMultiplexProgram(request))
}
