package zio.aws.medialive
import zio.aws.medialive.model.DescribeInputDeviceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.medialive.model.{
  ListMultiplexProgramsRequest,
  DescribeOfferingRequest,
  TransferInputDeviceRequest,
  PurchaseOfferingRequest,
  DescribeInputDeviceRequest,
  CreateMultiplexProgramRequest,
  StartChannelRequest,
  AcceptInputDeviceTransferRequest,
  CreatePartnerInputRequest,
  DeleteTagsRequest,
  ListOfferingsRequest,
  DeleteChannelRequest,
  UpdateMultiplexRequest,
  DeleteScheduleRequest,
  ListReservationsRequest,
  BatchStartRequest,
  RejectInputDeviceTransferRequest,
  CreateInputRequest,
  CreateChannelRequest,
  StopMultiplexRequest,
  DescribeReservationRequest,
  UpdateInputRequest,
  CreateTagsRequest,
  UpdateMultiplexProgramRequest,
  BatchDeleteRequest,
  ListTagsForResourceRequest,
  DescribeMultiplexRequest,
  ListInputSecurityGroupsRequest,
  DescribeInputRequest,
  DeleteMultiplexRequest,
  ListInputsRequest,
  ListMultiplexesRequest,
  UpdateInputSecurityGroupRequest,
  ClaimDeviceRequest,
  DescribeInputDeviceThumbnailRequest,
  DeleteInputRequest,
  UpdateChannelClassRequest,
  UpdateChannelRequest,
  DeleteMultiplexProgramRequest,
  DeleteInputSecurityGroupRequest,
  BatchStopRequest,
  ListInputDevicesRequest,
  CreateMultiplexRequest,
  DeleteReservationRequest,
  ListChannelsRequest,
  ListInputDeviceTransfersRequest,
  CreateInputSecurityGroupRequest,
  DescribeInputSecurityGroupRequest,
  BatchUpdateScheduleRequest,
  StartMultiplexRequest,
  StopChannelRequest,
  UpdateInputDeviceRequest,
  UpdateReservationRequest,
  DescribeChannelRequest,
  DescribeScheduleRequest,
  CancelInputDeviceTransferRequest,
  DescribeMultiplexProgramRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient
object MediaLiveMock extends Mock[MediaLive] {
  object UpdateMultiplexProgram
      extends Effect[
        UpdateMultiplexProgramRequest,
        AwsError,
        zio.aws.medialive.model.UpdateMultiplexProgramResponse.ReadOnly
      ]
  object DeleteReservation
      extends Effect[
        DeleteReservationRequest,
        AwsError,
        zio.aws.medialive.model.DeleteReservationResponse.ReadOnly
      ]
  object ListMultiplexes
      extends Stream[
        ListMultiplexesRequest,
        AwsError,
        zio.aws.medialive.model.MultiplexSummary.ReadOnly
      ]
  object ListMultiplexesPaginated
      extends Effect[
        ListMultiplexesRequest,
        AwsError,
        zio.aws.medialive.model.ListMultiplexesResponse.ReadOnly
      ]
  object CreateMultiplex
      extends Effect[
        CreateMultiplexRequest,
        AwsError,
        zio.aws.medialive.model.CreateMultiplexResponse.ReadOnly
      ]
  object ListChannels
      extends Stream[
        ListChannelsRequest,
        AwsError,
        zio.aws.medialive.model.ChannelSummary.ReadOnly
      ]
  object ListChannelsPaginated
      extends Effect[
        ListChannelsRequest,
        AwsError,
        zio.aws.medialive.model.ListChannelsResponse.ReadOnly
      ]
  object DescribeOffering
      extends Effect[
        DescribeOfferingRequest,
        AwsError,
        zio.aws.medialive.model.DescribeOfferingResponse.ReadOnly
      ]
  object DeleteMultiplex
      extends Effect[
        DeleteMultiplexRequest,
        AwsError,
        zio.aws.medialive.model.DeleteMultiplexResponse.ReadOnly
      ]
  object UpdateInputDevice
      extends Effect[
        UpdateInputDeviceRequest,
        AwsError,
        zio.aws.medialive.model.UpdateInputDeviceResponse.ReadOnly
      ]
  object BatchStop
      extends Effect[
        BatchStopRequest,
        AwsError,
        zio.aws.medialive.model.BatchStopResponse.ReadOnly
      ]
  object ListMultiplexPrograms
      extends Stream[
        ListMultiplexProgramsRequest,
        AwsError,
        zio.aws.medialive.model.MultiplexProgramSummary.ReadOnly
      ]
  object ListMultiplexProgramsPaginated
      extends Effect[
        ListMultiplexProgramsRequest,
        AwsError,
        zio.aws.medialive.model.ListMultiplexProgramsResponse.ReadOnly
      ]
  object ClaimDevice
      extends Effect[
        ClaimDeviceRequest,
        AwsError,
        zio.aws.medialive.model.ClaimDeviceResponse.ReadOnly
      ]
  object ListInputSecurityGroups
      extends Stream[
        ListInputSecurityGroupsRequest,
        AwsError,
        zio.aws.medialive.model.InputSecurityGroup.ReadOnly
      ]
  object ListInputSecurityGroupsPaginated
      extends Effect[
        ListInputSecurityGroupsRequest,
        AwsError,
        zio.aws.medialive.model.ListInputSecurityGroupsResponse.ReadOnly
      ]
  object AcceptInputDeviceTransfer
      extends Effect[
        AcceptInputDeviceTransferRequest,
        AwsError,
        zio.aws.medialive.model.AcceptInputDeviceTransferResponse.ReadOnly
      ]
  object CancelInputDeviceTransfer
      extends Effect[
        CancelInputDeviceTransferRequest,
        AwsError,
        zio.aws.medialive.model.CancelInputDeviceTransferResponse.ReadOnly
      ]
  object StopMultiplex
      extends Effect[
        StopMultiplexRequest,
        AwsError,
        zio.aws.medialive.model.StopMultiplexResponse.ReadOnly
      ]
  object BatchStart
      extends Effect[
        BatchStartRequest,
        AwsError,
        zio.aws.medialive.model.BatchStartResponse.ReadOnly
      ]
  object DescribeInputSecurityGroup
      extends Effect[
        DescribeInputSecurityGroupRequest,
        AwsError,
        zio.aws.medialive.model.DescribeInputSecurityGroupResponse.ReadOnly
      ]
  object DeleteChannel
      extends Effect[
        DeleteChannelRequest,
        AwsError,
        zio.aws.medialive.model.DeleteChannelResponse.ReadOnly
      ]
  object DeleteInput
      extends Effect[
        DeleteInputRequest,
        AwsError,
        zio.aws.medialive.model.DeleteInputResponse.ReadOnly
      ]
  object DescribeMultiplexProgram
      extends Effect[
        DescribeMultiplexProgramRequest,
        AwsError,
        zio.aws.medialive.model.DescribeMultiplexProgramResponse.ReadOnly
      ]
  object StartMultiplex
      extends Effect[
        StartMultiplexRequest,
        AwsError,
        zio.aws.medialive.model.StartMultiplexResponse.ReadOnly
      ]
  object StartChannel
      extends Effect[
        StartChannelRequest,
        AwsError,
        zio.aws.medialive.model.StartChannelResponse.ReadOnly
      ]
  object ListInputs
      extends Stream[
        ListInputsRequest,
        AwsError,
        zio.aws.medialive.model.Input.ReadOnly
      ]
  object ListInputsPaginated
      extends Effect[
        ListInputsRequest,
        AwsError,
        zio.aws.medialive.model.ListInputsResponse.ReadOnly
      ]
  object ListReservations
      extends Stream[
        ListReservationsRequest,
        AwsError,
        zio.aws.medialive.model.Reservation.ReadOnly
      ]
  object ListReservationsPaginated
      extends Effect[
        ListReservationsRequest,
        AwsError,
        zio.aws.medialive.model.ListReservationsResponse.ReadOnly
      ]
  object ListInputDevices
      extends Stream[
        ListInputDevicesRequest,
        AwsError,
        zio.aws.medialive.model.InputDeviceSummary.ReadOnly
      ]
  object ListInputDevicesPaginated
      extends Effect[
        ListInputDevicesRequest,
        AwsError,
        zio.aws.medialive.model.ListInputDevicesResponse.ReadOnly
      ]
  object ListInputDeviceTransfers
      extends Stream[
        ListInputDeviceTransfersRequest,
        AwsError,
        zio.aws.medialive.model.TransferringInputDeviceSummary.ReadOnly
      ]
  object ListInputDeviceTransfersPaginated
      extends Effect[
        ListInputDeviceTransfersRequest,
        AwsError,
        zio.aws.medialive.model.ListInputDeviceTransfersResponse.ReadOnly
      ]
  object UpdateInputSecurityGroup
      extends Effect[
        UpdateInputSecurityGroupRequest,
        AwsError,
        zio.aws.medialive.model.UpdateInputSecurityGroupResponse.ReadOnly
      ]
  object DescribeInputDeviceThumbnail
      extends Effect[
        DescribeInputDeviceThumbnailRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse.ReadOnly,
          Byte
        ]
      ]
  object DescribeReservation
      extends Effect[
        DescribeReservationRequest,
        AwsError,
        zio.aws.medialive.model.DescribeReservationResponse.ReadOnly
      ]
  object CreateChannel
      extends Effect[
        CreateChannelRequest,
        AwsError,
        zio.aws.medialive.model.CreateChannelResponse.ReadOnly
      ]
  object DescribeInputDevice
      extends Effect[DescribeInputDeviceRequest, AwsError, ReadOnly]
  object StopChannel
      extends Effect[
        StopChannelRequest,
        AwsError,
        zio.aws.medialive.model.StopChannelResponse.ReadOnly
      ]
  object CreateMultiplexProgram
      extends Effect[
        CreateMultiplexProgramRequest,
        AwsError,
        zio.aws.medialive.model.CreateMultiplexProgramResponse.ReadOnly
      ]
  object UpdateInput
      extends Effect[
        UpdateInputRequest,
        AwsError,
        zio.aws.medialive.model.UpdateInputResponse.ReadOnly
      ]
  object ListOfferings
      extends Stream[
        ListOfferingsRequest,
        AwsError,
        zio.aws.medialive.model.Offering.ReadOnly
      ]
  object ListOfferingsPaginated
      extends Effect[
        ListOfferingsRequest,
        AwsError,
        zio.aws.medialive.model.ListOfferingsResponse.ReadOnly
      ]
  object DescribeSchedule
      extends Stream[
        DescribeScheduleRequest,
        AwsError,
        zio.aws.medialive.model.ScheduleAction.ReadOnly
      ]
  object DescribeSchedulePaginated
      extends Effect[
        DescribeScheduleRequest,
        AwsError,
        zio.aws.medialive.model.DescribeScheduleResponse.ReadOnly
      ]
  object UpdateChannelClass
      extends Effect[
        UpdateChannelClassRequest,
        AwsError,
        zio.aws.medialive.model.UpdateChannelClassResponse.ReadOnly
      ]
  object DeleteInputSecurityGroup
      extends Effect[
        DeleteInputSecurityGroupRequest,
        AwsError,
        zio.aws.medialive.model.DeleteInputSecurityGroupResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.medialive.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeChannel
      extends Effect[
        DescribeChannelRequest,
        AwsError,
        zio.aws.medialive.model.DescribeChannelResponse.ReadOnly
      ]
  object CreatePartnerInput
      extends Effect[
        CreatePartnerInputRequest,
        AwsError,
        zio.aws.medialive.model.CreatePartnerInputResponse.ReadOnly
      ]
  object PurchaseOffering
      extends Effect[
        PurchaseOfferingRequest,
        AwsError,
        zio.aws.medialive.model.PurchaseOfferingResponse.ReadOnly
      ]
  object UpdateMultiplex
      extends Effect[
        UpdateMultiplexRequest,
        AwsError,
        zio.aws.medialive.model.UpdateMultiplexResponse.ReadOnly
      ]
  object DescribeMultiplex
      extends Effect[
        DescribeMultiplexRequest,
        AwsError,
        zio.aws.medialive.model.DescribeMultiplexResponse.ReadOnly
      ]
  object UpdateReservation
      extends Effect[
        UpdateReservationRequest,
        AwsError,
        zio.aws.medialive.model.UpdateReservationResponse.ReadOnly
      ]
  object BatchDelete
      extends Effect[
        BatchDeleteRequest,
        AwsError,
        zio.aws.medialive.model.BatchDeleteResponse.ReadOnly
      ]
  object DeleteTags extends Effect[DeleteTagsRequest, AwsError, Unit]
  object DeleteSchedule
      extends Effect[
        DeleteScheduleRequest,
        AwsError,
        zio.aws.medialive.model.DeleteScheduleResponse.ReadOnly
      ]
  object RejectInputDeviceTransfer
      extends Effect[
        RejectInputDeviceTransferRequest,
        AwsError,
        zio.aws.medialive.model.RejectInputDeviceTransferResponse.ReadOnly
      ]
  object BatchUpdateSchedule
      extends Effect[
        BatchUpdateScheduleRequest,
        AwsError,
        zio.aws.medialive.model.BatchUpdateScheduleResponse.ReadOnly
      ]
  object TransferInputDevice
      extends Effect[
        TransferInputDeviceRequest,
        AwsError,
        zio.aws.medialive.model.TransferInputDeviceResponse.ReadOnly
      ]
  object UpdateChannel
      extends Effect[
        UpdateChannelRequest,
        AwsError,
        zio.aws.medialive.model.UpdateChannelResponse.ReadOnly
      ]
  object DescribeInput
      extends Effect[
        DescribeInputRequest,
        AwsError,
        zio.aws.medialive.model.DescribeInputResponse.ReadOnly
      ]
  object CreateInput
      extends Effect[
        CreateInputRequest,
        AwsError,
        zio.aws.medialive.model.CreateInputResponse.ReadOnly
      ]
  object CreateInputSecurityGroup
      extends Effect[
        CreateInputSecurityGroupRequest,
        AwsError,
        zio.aws.medialive.model.CreateInputSecurityGroupResponse.ReadOnly
      ]
  object CreateTags extends Effect[CreateTagsRequest, AwsError, Unit]
  object DeleteMultiplexProgram
      extends Effect[
        DeleteMultiplexProgramRequest,
        AwsError,
        zio.aws.medialive.model.DeleteMultiplexProgramResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MediaLive] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new MediaLive {
          val api: MediaLiveAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : MediaLive = this
          def updateMultiplexProgram(
              request: UpdateMultiplexProgramRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.UpdateMultiplexProgramResponse.ReadOnly
          ] = proxy(UpdateMultiplexProgram, request)
          def deleteReservation(request: DeleteReservationRequest): IO[
            AwsError,
            zio.aws.medialive.model.DeleteReservationResponse.ReadOnly
          ] = proxy(DeleteReservation, request)
          def listMultiplexes(request: ListMultiplexesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.medialive.model.MultiplexSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListMultiplexes, request))
          def listMultiplexesPaginated(request: ListMultiplexesRequest): IO[
            AwsError,
            zio.aws.medialive.model.ListMultiplexesResponse.ReadOnly
          ] = proxy(ListMultiplexesPaginated, request)
          def createMultiplex(request: CreateMultiplexRequest): IO[
            AwsError,
            zio.aws.medialive.model.CreateMultiplexResponse.ReadOnly
          ] = proxy(CreateMultiplex, request)
          def listChannels(request: ListChannelsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.medialive.model.ChannelSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListChannels, request))
          def listChannelsPaginated(request: ListChannelsRequest): IO[
            AwsError,
            zio.aws.medialive.model.ListChannelsResponse.ReadOnly
          ] = proxy(ListChannelsPaginated, request)
          def describeOffering(request: DescribeOfferingRequest): IO[
            AwsError,
            zio.aws.medialive.model.DescribeOfferingResponse.ReadOnly
          ] = proxy(DescribeOffering, request)
          def deleteMultiplex(request: DeleteMultiplexRequest): IO[
            AwsError,
            zio.aws.medialive.model.DeleteMultiplexResponse.ReadOnly
          ] = proxy(DeleteMultiplex, request)
          def updateInputDevice(request: UpdateInputDeviceRequest): IO[
            AwsError,
            zio.aws.medialive.model.UpdateInputDeviceResponse.ReadOnly
          ] = proxy(UpdateInputDevice, request)
          def batchStop(
              request: BatchStopRequest
          ): IO[AwsError, zio.aws.medialive.model.BatchStopResponse.ReadOnly] =
            proxy(BatchStop, request)
          def listMultiplexPrograms(
              request: ListMultiplexProgramsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.medialive.model.MultiplexProgramSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListMultiplexPrograms, request))
          def listMultiplexProgramsPaginated(
              request: ListMultiplexProgramsRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.ListMultiplexProgramsResponse.ReadOnly
          ] = proxy(ListMultiplexProgramsPaginated, request)
          def claimDevice(request: ClaimDeviceRequest): IO[
            AwsError,
            zio.aws.medialive.model.ClaimDeviceResponse.ReadOnly
          ] = proxy(ClaimDevice, request)
          def listInputSecurityGroups(
              request: ListInputSecurityGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.medialive.model.InputSecurityGroup.ReadOnly
          ] = rts.unsafeRun(proxy(ListInputSecurityGroups, request))
          def listInputSecurityGroupsPaginated(
              request: ListInputSecurityGroupsRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.ListInputSecurityGroupsResponse.ReadOnly
          ] = proxy(ListInputSecurityGroupsPaginated, request)
          def acceptInputDeviceTransfer(
              request: AcceptInputDeviceTransferRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.AcceptInputDeviceTransferResponse.ReadOnly
          ] = proxy(AcceptInputDeviceTransfer, request)
          def cancelInputDeviceTransfer(
              request: CancelInputDeviceTransferRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.CancelInputDeviceTransferResponse.ReadOnly
          ] = proxy(CancelInputDeviceTransfer, request)
          def stopMultiplex(request: StopMultiplexRequest): IO[
            AwsError,
            zio.aws.medialive.model.StopMultiplexResponse.ReadOnly
          ] = proxy(StopMultiplex, request)
          def batchStart(
              request: BatchStartRequest
          ): IO[AwsError, zio.aws.medialive.model.BatchStartResponse.ReadOnly] =
            proxy(BatchStart, request)
          def describeInputSecurityGroup(
              request: DescribeInputSecurityGroupRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.DescribeInputSecurityGroupResponse.ReadOnly
          ] = proxy(DescribeInputSecurityGroup, request)
          def deleteChannel(request: DeleteChannelRequest): IO[
            AwsError,
            zio.aws.medialive.model.DeleteChannelResponse.ReadOnly
          ] = proxy(DeleteChannel, request)
          def deleteInput(request: DeleteInputRequest): IO[
            AwsError,
            zio.aws.medialive.model.DeleteInputResponse.ReadOnly
          ] = proxy(DeleteInput, request)
          def describeMultiplexProgram(
              request: DescribeMultiplexProgramRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.DescribeMultiplexProgramResponse.ReadOnly
          ] = proxy(DescribeMultiplexProgram, request)
          def startMultiplex(request: StartMultiplexRequest): IO[
            AwsError,
            zio.aws.medialive.model.StartMultiplexResponse.ReadOnly
          ] = proxy(StartMultiplex, request)
          def startChannel(request: StartChannelRequest): IO[
            AwsError,
            zio.aws.medialive.model.StartChannelResponse.ReadOnly
          ] = proxy(StartChannel, request)
          def listInputs(
              request: ListInputsRequest
          ): ZStream[Any, AwsError, zio.aws.medialive.model.Input.ReadOnly] =
            rts.unsafeRun(proxy(ListInputs, request))
          def listInputsPaginated(
              request: ListInputsRequest
          ): IO[AwsError, zio.aws.medialive.model.ListInputsResponse.ReadOnly] =
            proxy(ListInputsPaginated, request)
          def listReservations(request: ListReservationsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.medialive.model.Reservation.ReadOnly
          ] = rts.unsafeRun(proxy(ListReservations, request))
          def listReservationsPaginated(request: ListReservationsRequest): IO[
            AwsError,
            zio.aws.medialive.model.ListReservationsResponse.ReadOnly
          ] = proxy(ListReservationsPaginated, request)
          def listInputDevices(request: ListInputDevicesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.medialive.model.InputDeviceSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListInputDevices, request))
          def listInputDevicesPaginated(request: ListInputDevicesRequest): IO[
            AwsError,
            zio.aws.medialive.model.ListInputDevicesResponse.ReadOnly
          ] = proxy(ListInputDevicesPaginated, request)
          def listInputDeviceTransfers(
              request: ListInputDeviceTransfersRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.medialive.model.TransferringInputDeviceSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListInputDeviceTransfers, request))
          def listInputDeviceTransfersPaginated(
              request: ListInputDeviceTransfersRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.ListInputDeviceTransfersResponse.ReadOnly
          ] = proxy(ListInputDeviceTransfersPaginated, request)
          def updateInputSecurityGroup(
              request: UpdateInputSecurityGroupRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.UpdateInputSecurityGroupResponse.ReadOnly
          ] = proxy(UpdateInputSecurityGroup, request)
          def describeInputDeviceThumbnail(
              request: DescribeInputDeviceThumbnailRequest
          ): IO[AwsError, StreamingOutputResult[
            Any,
            zio.aws.medialive.model.DescribeInputDeviceThumbnailResponse.ReadOnly,
            Byte
          ]] = proxy(DescribeInputDeviceThumbnail, request)
          def describeReservation(request: DescribeReservationRequest): IO[
            AwsError,
            zio.aws.medialive.model.DescribeReservationResponse.ReadOnly
          ] = proxy(DescribeReservation, request)
          def createChannel(request: CreateChannelRequest): IO[
            AwsError,
            zio.aws.medialive.model.CreateChannelResponse.ReadOnly
          ] = proxy(CreateChannel, request)
          def describeInputDevice(
              request: DescribeInputDeviceRequest
          ): IO[AwsError, ReadOnly] = proxy(DescribeInputDevice, request)
          def stopChannel(request: StopChannelRequest): IO[
            AwsError,
            zio.aws.medialive.model.StopChannelResponse.ReadOnly
          ] = proxy(StopChannel, request)
          def createMultiplexProgram(
              request: CreateMultiplexProgramRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.CreateMultiplexProgramResponse.ReadOnly
          ] = proxy(CreateMultiplexProgram, request)
          def updateInput(request: UpdateInputRequest): IO[
            AwsError,
            zio.aws.medialive.model.UpdateInputResponse.ReadOnly
          ] = proxy(UpdateInput, request)
          def listOfferings(
              request: ListOfferingsRequest
          ): ZStream[Any, AwsError, zio.aws.medialive.model.Offering.ReadOnly] =
            rts.unsafeRun(proxy(ListOfferings, request))
          def listOfferingsPaginated(request: ListOfferingsRequest): IO[
            AwsError,
            zio.aws.medialive.model.ListOfferingsResponse.ReadOnly
          ] = proxy(ListOfferingsPaginated, request)
          def describeSchedule(request: DescribeScheduleRequest): ZStream[
            Any,
            AwsError,
            zio.aws.medialive.model.ScheduleAction.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeSchedule, request))
          def describeSchedulePaginated(request: DescribeScheduleRequest): IO[
            AwsError,
            zio.aws.medialive.model.DescribeScheduleResponse.ReadOnly
          ] = proxy(DescribeSchedulePaginated, request)
          def updateChannelClass(request: UpdateChannelClassRequest): IO[
            AwsError,
            zio.aws.medialive.model.UpdateChannelClassResponse.ReadOnly
          ] = proxy(UpdateChannelClass, request)
          def deleteInputSecurityGroup(
              request: DeleteInputSecurityGroupRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.DeleteInputSecurityGroupResponse.ReadOnly
          ] = proxy(DeleteInputSecurityGroup, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.medialive.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def describeChannel(request: DescribeChannelRequest): IO[
            AwsError,
            zio.aws.medialive.model.DescribeChannelResponse.ReadOnly
          ] = proxy(DescribeChannel, request)
          def createPartnerInput(request: CreatePartnerInputRequest): IO[
            AwsError,
            zio.aws.medialive.model.CreatePartnerInputResponse.ReadOnly
          ] = proxy(CreatePartnerInput, request)
          def purchaseOffering(request: PurchaseOfferingRequest): IO[
            AwsError,
            zio.aws.medialive.model.PurchaseOfferingResponse.ReadOnly
          ] = proxy(PurchaseOffering, request)
          def updateMultiplex(request: UpdateMultiplexRequest): IO[
            AwsError,
            zio.aws.medialive.model.UpdateMultiplexResponse.ReadOnly
          ] = proxy(UpdateMultiplex, request)
          def describeMultiplex(request: DescribeMultiplexRequest): IO[
            AwsError,
            zio.aws.medialive.model.DescribeMultiplexResponse.ReadOnly
          ] = proxy(DescribeMultiplex, request)
          def updateReservation(request: UpdateReservationRequest): IO[
            AwsError,
            zio.aws.medialive.model.UpdateReservationResponse.ReadOnly
          ] = proxy(UpdateReservation, request)
          def batchDelete(request: BatchDeleteRequest): IO[
            AwsError,
            zio.aws.medialive.model.BatchDeleteResponse.ReadOnly
          ] = proxy(BatchDelete, request)
          def deleteTags(request: DeleteTagsRequest): IO[AwsError, Unit] =
            proxy(DeleteTags, request)
          def deleteSchedule(request: DeleteScheduleRequest): IO[
            AwsError,
            zio.aws.medialive.model.DeleteScheduleResponse.ReadOnly
          ] = proxy(DeleteSchedule, request)
          def rejectInputDeviceTransfer(
              request: RejectInputDeviceTransferRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.RejectInputDeviceTransferResponse.ReadOnly
          ] = proxy(RejectInputDeviceTransfer, request)
          def batchUpdateSchedule(request: BatchUpdateScheduleRequest): IO[
            AwsError,
            zio.aws.medialive.model.BatchUpdateScheduleResponse.ReadOnly
          ] = proxy(BatchUpdateSchedule, request)
          def transferInputDevice(request: TransferInputDeviceRequest): IO[
            AwsError,
            zio.aws.medialive.model.TransferInputDeviceResponse.ReadOnly
          ] = proxy(TransferInputDevice, request)
          def updateChannel(request: UpdateChannelRequest): IO[
            AwsError,
            zio.aws.medialive.model.UpdateChannelResponse.ReadOnly
          ] = proxy(UpdateChannel, request)
          def describeInput(request: DescribeInputRequest): IO[
            AwsError,
            zio.aws.medialive.model.DescribeInputResponse.ReadOnly
          ] = proxy(DescribeInput, request)
          def createInput(request: CreateInputRequest): IO[
            AwsError,
            zio.aws.medialive.model.CreateInputResponse.ReadOnly
          ] = proxy(CreateInput, request)
          def createInputSecurityGroup(
              request: CreateInputSecurityGroupRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.CreateInputSecurityGroupResponse.ReadOnly
          ] = proxy(CreateInputSecurityGroup, request)
          def createTags(request: CreateTagsRequest): IO[AwsError, Unit] =
            proxy(CreateTags, request)
          def deleteMultiplexProgram(
              request: DeleteMultiplexProgramRequest
          ): IO[
            AwsError,
            zio.aws.medialive.model.DeleteMultiplexProgramResponse.ReadOnly
          ] = proxy(DeleteMultiplexProgram, request)
        }
      }
    }
    .toLayer
}
