package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AacCodingMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.AacCodingMode
}
object AacCodingMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AacCodingMode
  ): zio.aws.medialive.model.AacCodingMode = value match {
    case software.amazon.awssdk.services.medialive.model.AacCodingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AacCodingMode.AD_RECEIVER_MIX =>
      val r = AD_RECEIVER_MIX
      r
    case software.amazon.awssdk.services.medialive.model.AacCodingMode.CODING_MODE_1_0 =>
      val r = CODING_MODE_1_0
      r
    case software.amazon.awssdk.services.medialive.model.AacCodingMode.CODING_MODE_1_1 =>
      val r = CODING_MODE_1_1
      r
    case software.amazon.awssdk.services.medialive.model.AacCodingMode.CODING_MODE_2_0 =>
      val r = CODING_MODE_2_0
      r
    case software.amazon.awssdk.services.medialive.model.AacCodingMode.CODING_MODE_5_1 =>
      val r = CODING_MODE_5_1
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.AacCodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacCodingMode =
      software.amazon.awssdk.services.medialive.model.AacCodingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object AD_RECEIVER_MIX extends zio.aws.medialive.model.AacCodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacCodingMode =
      software.amazon.awssdk.services.medialive.model.AacCodingMode.AD_RECEIVER_MIX
  }
  case object CODING_MODE_1_0 extends zio.aws.medialive.model.AacCodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacCodingMode =
      software.amazon.awssdk.services.medialive.model.AacCodingMode.CODING_MODE_1_0
  }
  case object CODING_MODE_1_1 extends zio.aws.medialive.model.AacCodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacCodingMode =
      software.amazon.awssdk.services.medialive.model.AacCodingMode.CODING_MODE_1_1
  }
  case object CODING_MODE_2_0 extends zio.aws.medialive.model.AacCodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacCodingMode =
      software.amazon.awssdk.services.medialive.model.AacCodingMode.CODING_MODE_2_0
  }
  case object CODING_MODE_5_1 extends zio.aws.medialive.model.AacCodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacCodingMode =
      software.amazon.awssdk.services.medialive.model.AacCodingMode.CODING_MODE_5_1
  }
}
