package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AacInputType {
  def unwrap: software.amazon.awssdk.services.medialive.model.AacInputType
}
object AacInputType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AacInputType
  ): zio.aws.medialive.model.AacInputType = value match {
    case software.amazon.awssdk.services.medialive.model.AacInputType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AacInputType.BROADCASTER_MIXED_AD =>
      val r = BROADCASTER_MIXED_AD
      r
    case software.amazon.awssdk.services.medialive.model.AacInputType.NORMAL =>
      val r = NORMAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.AacInputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacInputType =
      software.amazon.awssdk.services.medialive.model.AacInputType.UNKNOWN_TO_SDK_VERSION
  }
  case object BROADCASTER_MIXED_AD
      extends zio.aws.medialive.model.AacInputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacInputType =
      software.amazon.awssdk.services.medialive.model.AacInputType.BROADCASTER_MIXED_AD
  }
  case object NORMAL extends zio.aws.medialive.model.AacInputType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacInputType =
      software.amazon.awssdk.services.medialive.model.AacInputType.NORMAL
  }
}
