package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AacProfile {
  def unwrap: software.amazon.awssdk.services.medialive.model.AacProfile
}
object AacProfile {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AacProfile
  ): zio.aws.medialive.model.AacProfile = value match {
    case software.amazon.awssdk.services.medialive.model.AacProfile.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AacProfile.HEV1 =>
      val r = HEV1
      r
    case software.amazon.awssdk.services.medialive.model.AacProfile.HEV2 =>
      val r = HEV2
      r
    case software.amazon.awssdk.services.medialive.model.AacProfile.LC =>
      val r = LC
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.AacProfile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacProfile =
      software.amazon.awssdk.services.medialive.model.AacProfile.UNKNOWN_TO_SDK_VERSION
  }
  case object HEV1 extends zio.aws.medialive.model.AacProfile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacProfile =
      software.amazon.awssdk.services.medialive.model.AacProfile.HEV1
  }
  case object HEV2 extends zio.aws.medialive.model.AacProfile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacProfile =
      software.amazon.awssdk.services.medialive.model.AacProfile.HEV2
  }
  case object LC extends zio.aws.medialive.model.AacProfile {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacProfile =
      software.amazon.awssdk.services.medialive.model.AacProfile.LC
  }
}
