package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AacRateControlMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.AacRateControlMode
}
object AacRateControlMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AacRateControlMode
  ): zio.aws.medialive.model.AacRateControlMode = value match {
    case software.amazon.awssdk.services.medialive.model.AacRateControlMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AacRateControlMode.CBR =>
      val r = CBR
      r
    case software.amazon.awssdk.services.medialive.model.AacRateControlMode.VBR =>
      val r = VBR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.AacRateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacRateControlMode =
      software.amazon.awssdk.services.medialive.model.AacRateControlMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CBR extends zio.aws.medialive.model.AacRateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacRateControlMode =
      software.amazon.awssdk.services.medialive.model.AacRateControlMode.CBR
  }
  case object VBR extends zio.aws.medialive.model.AacRateControlMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacRateControlMode =
      software.amazon.awssdk.services.medialive.model.AacRateControlMode.VBR
  }
}
