package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AacRawFormat {
  def unwrap: software.amazon.awssdk.services.medialive.model.AacRawFormat
}
object AacRawFormat {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AacRawFormat
  ): zio.aws.medialive.model.AacRawFormat = value match {
    case software.amazon.awssdk.services.medialive.model.AacRawFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AacRawFormat.LATM_LOAS =>
      val r = LATM_LOAS
      r
    case software.amazon.awssdk.services.medialive.model.AacRawFormat.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.AacRawFormat {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacRawFormat =
      software.amazon.awssdk.services.medialive.model.AacRawFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object LATM_LOAS extends zio.aws.medialive.model.AacRawFormat {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacRawFormat =
      software.amazon.awssdk.services.medialive.model.AacRawFormat.LATM_LOAS
  }
  case object NONE extends zio.aws.medialive.model.AacRawFormat {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacRawFormat =
      software.amazon.awssdk.services.medialive.model.AacRawFormat.NONE
  }
}
