package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__double
import scala.jdk.CollectionConverters._
final case class AacSettings(
    bitrate: Option[__double] = None,
    codingMode: Option[zio.aws.medialive.model.AacCodingMode] = None,
    inputType: Option[zio.aws.medialive.model.AacInputType] = None,
    profile: Option[zio.aws.medialive.model.AacProfile] = None,
    rateControlMode: Option[zio.aws.medialive.model.AacRateControlMode] = None,
    rawFormat: Option[zio.aws.medialive.model.AacRawFormat] = None,
    sampleRate: Option[__double] = None,
    spec: Option[zio.aws.medialive.model.AacSpec] = None,
    vbrQuality: Option[zio.aws.medialive.model.AacVbrQuality] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AacSettings = {
    import AacSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AacSettings
      .builder()
      .optionallyWith(bitrate.map(value => value: java.lang.Double))(_.bitrate)
      .optionallyWith(codingMode.map(value => value.unwrap))(_.codingMode)
      .optionallyWith(inputType.map(value => value.unwrap))(_.inputType)
      .optionallyWith(profile.map(value => value.unwrap))(_.profile)
      .optionallyWith(rateControlMode.map(value => value.unwrap))(
        _.rateControlMode
      )
      .optionallyWith(rawFormat.map(value => value.unwrap))(_.rawFormat)
      .optionallyWith(sampleRate.map(value => value: java.lang.Double))(
        _.sampleRate
      )
      .optionallyWith(spec.map(value => value.unwrap))(_.spec)
      .optionallyWith(vbrQuality.map(value => value.unwrap))(_.vbrQuality)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AacSettings.ReadOnly =
    zio.aws.medialive.model.AacSettings.wrap(buildAwsValue())
}
object AacSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AacSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AacSettings =
      zio.aws.medialive.model.AacSettings(
        bitrate.map(value => value),
        codingMode.map(value => value),
        inputType.map(value => value),
        profile.map(value => value),
        rateControlMode.map(value => value),
        rawFormat.map(value => value),
        sampleRate.map(value => value),
        spec.map(value => value),
        vbrQuality.map(value => value)
      )
    def bitrate: Option[__double]
    def codingMode: Option[zio.aws.medialive.model.AacCodingMode]
    def inputType: Option[zio.aws.medialive.model.AacInputType]
    def profile: Option[zio.aws.medialive.model.AacProfile]
    def rateControlMode: Option[zio.aws.medialive.model.AacRateControlMode]
    def rawFormat: Option[zio.aws.medialive.model.AacRawFormat]
    def sampleRate: Option[__double]
    def spec: Option[zio.aws.medialive.model.AacSpec]
    def vbrQuality: Option[zio.aws.medialive.model.AacVbrQuality]
    def getBitrate: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("bitrate", bitrate)
    def getCodingMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.AacCodingMode] =
      AwsError.unwrapOptionField("codingMode", codingMode)
    def getInputType: ZIO[Any, AwsError, zio.aws.medialive.model.AacInputType] =
      AwsError.unwrapOptionField("inputType", inputType)
    def getProfile: ZIO[Any, AwsError, zio.aws.medialive.model.AacProfile] =
      AwsError.unwrapOptionField("profile", profile)
    def getRateControlMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.AacRateControlMode] =
      AwsError.unwrapOptionField("rateControlMode", rateControlMode)
    def getRawFormat: ZIO[Any, AwsError, zio.aws.medialive.model.AacRawFormat] =
      AwsError.unwrapOptionField("rawFormat", rawFormat)
    def getSampleRate: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
    def getSpec: ZIO[Any, AwsError, zio.aws.medialive.model.AacSpec] =
      AwsError.unwrapOptionField("spec", spec)
    def getVbrQuality
        : ZIO[Any, AwsError, zio.aws.medialive.model.AacVbrQuality] =
      AwsError.unwrapOptionField("vbrQuality", vbrQuality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AacSettings
  ) extends zio.aws.medialive.model.AacSettings.ReadOnly {
    override val bitrate: Option[__double] =
      scala.Option(impl.bitrate()).map(value => value: __double)
    override val codingMode: Option[zio.aws.medialive.model.AacCodingMode] =
      scala
        .Option(impl.codingMode())
        .map(value => zio.aws.medialive.model.AacCodingMode.wrap(value))
    override val inputType: Option[zio.aws.medialive.model.AacInputType] = scala
      .Option(impl.inputType())
      .map(value => zio.aws.medialive.model.AacInputType.wrap(value))
    override val profile: Option[zio.aws.medialive.model.AacProfile] = scala
      .Option(impl.profile())
      .map(value => zio.aws.medialive.model.AacProfile.wrap(value))
    override val rateControlMode
        : Option[zio.aws.medialive.model.AacRateControlMode] = scala
      .Option(impl.rateControlMode())
      .map(value => zio.aws.medialive.model.AacRateControlMode.wrap(value))
    override val rawFormat: Option[zio.aws.medialive.model.AacRawFormat] = scala
      .Option(impl.rawFormat())
      .map(value => zio.aws.medialive.model.AacRawFormat.wrap(value))
    override val sampleRate: Option[__double] =
      scala.Option(impl.sampleRate()).map(value => value: __double)
    override val spec: Option[zio.aws.medialive.model.AacSpec] = scala
      .Option(impl.spec())
      .map(value => zio.aws.medialive.model.AacSpec.wrap(value))
    override val vbrQuality: Option[zio.aws.medialive.model.AacVbrQuality] =
      scala
        .Option(impl.vbrQuality())
        .map(value => zio.aws.medialive.model.AacVbrQuality.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AacSettings
  ): zio.aws.medialive.model.AacSettings.ReadOnly = new Wrapper(impl)
}
