package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AacSpec {
  def unwrap: software.amazon.awssdk.services.medialive.model.AacSpec
}
object AacSpec {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AacSpec
  ): zio.aws.medialive.model.AacSpec = value match {
    case software.amazon.awssdk.services.medialive.model.AacSpec.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AacSpec.MPEG2 =>
      val r = MPEG2
      r
    case software.amazon.awssdk.services.medialive.model.AacSpec.MPEG4 =>
      val r = MPEG4
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.AacSpec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacSpec =
      software.amazon.awssdk.services.medialive.model.AacSpec.UNKNOWN_TO_SDK_VERSION
  }
  case object MPEG2 extends zio.aws.medialive.model.AacSpec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacSpec =
      software.amazon.awssdk.services.medialive.model.AacSpec.MPEG2
  }
  case object MPEG4 extends zio.aws.medialive.model.AacSpec {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AacSpec =
      software.amazon.awssdk.services.medialive.model.AacSpec.MPEG4
  }
}
