package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Ac3BitstreamMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode
}
object Ac3BitstreamMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode
  ): zio.aws.medialive.model.Ac3BitstreamMode = value match {
    case software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.COMMENTARY =>
      val r = COMMENTARY
      r
    case software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.COMPLETE_MAIN =>
      val r = COMPLETE_MAIN
      r
    case software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.DIALOGUE =>
      val r = DIALOGUE
      r
    case software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.EMERGENCY =>
      val r = EMERGENCY
      r
    case software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.HEARING_IMPAIRED =>
      val r = HEARING_IMPAIRED
      r
    case software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.MUSIC_AND_EFFECTS =>
      val r = MUSIC_AND_EFFECTS
      r
    case software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.VISUALLY_IMPAIRED =>
      val r = VISUALLY_IMPAIRED
      r
    case software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.VOICE_OVER =>
      val r = VOICE_OVER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Ac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.UNKNOWN_TO_SDK_VERSION
  }
  case object COMMENTARY extends zio.aws.medialive.model.Ac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.COMMENTARY
  }
  case object COMPLETE_MAIN extends zio.aws.medialive.model.Ac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.COMPLETE_MAIN
  }
  case object DIALOGUE extends zio.aws.medialive.model.Ac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.DIALOGUE
  }
  case object EMERGENCY extends zio.aws.medialive.model.Ac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.EMERGENCY
  }
  case object HEARING_IMPAIRED
      extends zio.aws.medialive.model.Ac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.HEARING_IMPAIRED
  }
  case object MUSIC_AND_EFFECTS
      extends zio.aws.medialive.model.Ac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.MUSIC_AND_EFFECTS
  }
  case object VISUALLY_IMPAIRED
      extends zio.aws.medialive.model.Ac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.VISUALLY_IMPAIRED
  }
  case object VOICE_OVER extends zio.aws.medialive.model.Ac3BitstreamMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode =
      software.amazon.awssdk.services.medialive.model.Ac3BitstreamMode.VOICE_OVER
  }
}
